/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LiteralOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LiteralOptions> {
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultValue").getter(LiteralOptions.getter(LiteralOptions::defaultValue)).setter(LiteralOptions.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final SdkField<String> SOURCE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceField").getter(LiteralOptions.getter(LiteralOptions::sourceField)).setter(LiteralOptions.setter(Builder::sourceField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceField").build()}).build();
    private static final SdkField<Boolean> FACET_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FacetEnabled").getter(LiteralOptions.getter(LiteralOptions::facetEnabled)).setter(LiteralOptions.setter(Builder::facetEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetEnabled").build()}).build();
    private static final SdkField<Boolean> SEARCH_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SearchEnabled").getter(LiteralOptions.getter(LiteralOptions::searchEnabled)).setter(LiteralOptions.setter(Builder::searchEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchEnabled").build()}).build();
    private static final SdkField<Boolean> RETURN_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReturnEnabled").getter(LiteralOptions.getter(LiteralOptions::returnEnabled)).setter(LiteralOptions.setter(Builder::returnEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnEnabled").build()}).build();
    private static final SdkField<Boolean> SORT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SortEnabled").getter(LiteralOptions.getter(LiteralOptions::sortEnabled)).setter(LiteralOptions.setter(Builder::sortEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD, SOURCE_FIELD_FIELD, FACET_ENABLED_FIELD, SEARCH_ENABLED_FIELD, RETURN_ENABLED_FIELD, SORT_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LiteralOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String defaultValue;
    private final String sourceField;
    private final Boolean facetEnabled;
    private final Boolean searchEnabled;
    private final Boolean returnEnabled;
    private final Boolean sortEnabled;

    private LiteralOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.sourceField = builder.sourceField;
        this.facetEnabled = builder.facetEnabled;
        this.searchEnabled = builder.searchEnabled;
        this.returnEnabled = builder.returnEnabled;
        this.sortEnabled = builder.sortEnabled;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final String sourceField() {
        return this.sourceField;
    }

    public final Boolean facetEnabled() {
        return this.facetEnabled;
    }

    public final Boolean searchEnabled() {
        return this.searchEnabled;
    }

    public final Boolean returnEnabled() {
        return this.returnEnabled;
    }

    public final Boolean sortEnabled() {
        return this.sortEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceField());
        hashCode = 31 * hashCode + Objects.hashCode(this.facetEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiteralOptions)) {
            return false;
        }
        LiteralOptions other = (LiteralOptions)obj;
        return Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.sourceField(), other.sourceField()) && Objects.equals(this.facetEnabled(), other.facetEnabled()) && Objects.equals(this.searchEnabled(), other.searchEnabled()) && Objects.equals(this.returnEnabled(), other.returnEnabled()) && Objects.equals(this.sortEnabled(), other.sortEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"LiteralOptions").add("DefaultValue", (Object)this.defaultValue()).add("SourceField", (Object)this.sourceField()).add("FacetEnabled", (Object)this.facetEnabled()).add("SearchEnabled", (Object)this.searchEnabled()).add("ReturnEnabled", (Object)this.returnEnabled()).add("SortEnabled", (Object)this.sortEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "SourceField": {
                return Optional.ofNullable(clazz.cast(this.sourceField()));
            }
            case "FacetEnabled": {
                return Optional.ofNullable(clazz.cast(this.facetEnabled()));
            }
            case "SearchEnabled": {
                return Optional.ofNullable(clazz.cast(this.searchEnabled()));
            }
            case "ReturnEnabled": {
                return Optional.ofNullable(clazz.cast(this.returnEnabled()));
            }
            case "SortEnabled": {
                return Optional.ofNullable(clazz.cast(this.sortEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        map.put("SourceField", SOURCE_FIELD_FIELD);
        map.put("FacetEnabled", FACET_ENABLED_FIELD);
        map.put("SearchEnabled", SEARCH_ENABLED_FIELD);
        map.put("ReturnEnabled", RETURN_ENABLED_FIELD);
        map.put("SortEnabled", SORT_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LiteralOptions, T> g) {
        return obj -> g.apply((LiteralOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultValue;
        private String sourceField;
        private Boolean facetEnabled;
        private Boolean searchEnabled;
        private Boolean returnEnabled;
        private Boolean sortEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(LiteralOptions model) {
            this.defaultValue(model.defaultValue);
            this.sourceField(model.sourceField);
            this.facetEnabled(model.facetEnabled);
            this.searchEnabled(model.searchEnabled);
            this.returnEnabled(model.returnEnabled);
            this.sortEnabled(model.sortEnabled);
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getSourceField() {
            return this.sourceField;
        }

        public final void setSourceField(String sourceField) {
            this.sourceField = sourceField;
        }

        @Override
        public final Builder sourceField(String sourceField) {
            this.sourceField = sourceField;
            return this;
        }

        public final Boolean getFacetEnabled() {
            return this.facetEnabled;
        }

        public final void setFacetEnabled(Boolean facetEnabled) {
            this.facetEnabled = facetEnabled;
        }

        @Override
        public final Builder facetEnabled(Boolean facetEnabled) {
            this.facetEnabled = facetEnabled;
            return this;
        }

        public final Boolean getSearchEnabled() {
            return this.searchEnabled;
        }

        public final void setSearchEnabled(Boolean searchEnabled) {
            this.searchEnabled = searchEnabled;
        }

        @Override
        public final Builder searchEnabled(Boolean searchEnabled) {
            this.searchEnabled = searchEnabled;
            return this;
        }

        public final Boolean getReturnEnabled() {
            return this.returnEnabled;
        }

        public final void setReturnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
        }

        @Override
        public final Builder returnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
            return this;
        }

        public final Boolean getSortEnabled() {
            return this.sortEnabled;
        }

        public final void setSortEnabled(Boolean sortEnabled) {
            this.sortEnabled = sortEnabled;
        }

        @Override
        public final Builder sortEnabled(Boolean sortEnabled) {
            this.sortEnabled = sortEnabled;
            return this;
        }

        public LiteralOptions build() {
            return new LiteralOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LiteralOptions> {
        public Builder defaultValue(String var1);

        public Builder sourceField(String var1);

        public Builder facetEnabled(Boolean var1);

        public Builder searchEnabled(Boolean var1);

        public Builder returnEnabled(Boolean var1);

        public Builder sortEnabled(Boolean var1);
    }
}

