/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsResponse;

public class GetQueryResultsIterable
implements SdkIterable<GetQueryResultsResponse> {
    private final CloudTrailClient client;
    private final GetQueryResultsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetQueryResultsIterable(CloudTrailClient client, GetQueryResultsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetQueryResultsResponseFetcher();
    }

    public Iterator<GetQueryResultsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetQueryResultsResponseFetcher
    implements SyncPageFetcher<GetQueryResultsResponse> {
        private GetQueryResultsResponseFetcher() {
        }

        public boolean hasNextPage(GetQueryResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetQueryResultsResponse nextPage(GetQueryResultsResponse previousPage) {
            if (previousPage == null) {
                return GetQueryResultsIterable.this.client.getQueryResults(GetQueryResultsIterable.this.firstRequest);
            }
            return GetQueryResultsIterable.this.client.getQueryResults((GetQueryResultsRequest)((Object)GetQueryResultsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

