/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListQueriesResponse;

public class ListQueriesIterable
implements SdkIterable<ListQueriesResponse> {
    private final CloudTrailClient client;
    private final ListQueriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQueriesIterable(CloudTrailClient client, ListQueriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListQueriesResponseFetcher();
    }

    public Iterator<ListQueriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListQueriesResponseFetcher
    implements SyncPageFetcher<ListQueriesResponse> {
        private ListQueriesResponseFetcher() {
        }

        public boolean hasNextPage(ListQueriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListQueriesResponse nextPage(ListQueriesResponse previousPage) {
            if (previousPage == null) {
                return ListQueriesIterable.this.client.listQueries(ListQueriesIterable.this.firstRequest);
            }
            return ListQueriesIterable.this.client.listQueries((ListQueriesRequest)((Object)ListQueriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

