/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.AggregationConfiguration;
import software.amazon.awssdk.services.cloudtrail.model.AggregationConfigurationsCopier;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.ContextKeySelector;
import software.amazon.awssdk.services.cloudtrail.model.ContextKeySelectorsCopier;
import software.amazon.awssdk.services.cloudtrail.model.MaxEventSize;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEventConfigurationResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, PutEventConfigurationResponse> {
    private static final SdkField<String> TRAIL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrailARN").getter(PutEventConfigurationResponse.getter(PutEventConfigurationResponse::trailARN)).setter(PutEventConfigurationResponse.setter(Builder::trailARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailARN").build()}).build();
    private static final SdkField<String> EVENT_DATA_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDataStoreArn").getter(PutEventConfigurationResponse.getter(PutEventConfigurationResponse::eventDataStoreArn)).setter(PutEventConfigurationResponse.setter(Builder::eventDataStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStoreArn").build()}).build();
    private static final SdkField<String> MAX_EVENT_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxEventSize").getter(PutEventConfigurationResponse.getter(PutEventConfigurationResponse::maxEventSizeAsString)).setter(PutEventConfigurationResponse.setter(Builder::maxEventSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxEventSize").build()}).build();
    private static final SdkField<List<ContextKeySelector>> CONTEXT_KEY_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContextKeySelectors").getter(PutEventConfigurationResponse.getter(PutEventConfigurationResponse::contextKeySelectors)).setter(PutEventConfigurationResponse.setter(Builder::contextKeySelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextKeySelectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContextKeySelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AggregationConfiguration>> AGGREGATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AggregationConfigurations").getter(PutEventConfigurationResponse.getter(PutEventConfigurationResponse::aggregationConfigurations)).setter(PutEventConfigurationResponse.setter(Builder::aggregationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_ARN_FIELD, EVENT_DATA_STORE_ARN_FIELD, MAX_EVENT_SIZE_FIELD, CONTEXT_KEY_SELECTORS_FIELD, AGGREGATION_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutEventConfigurationResponse.memberNameToFieldInitializer();
    private final String trailARN;
    private final String eventDataStoreArn;
    private final String maxEventSize;
    private final List<ContextKeySelector> contextKeySelectors;
    private final List<AggregationConfiguration> aggregationConfigurations;

    private PutEventConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.trailARN = builder.trailARN;
        this.eventDataStoreArn = builder.eventDataStoreArn;
        this.maxEventSize = builder.maxEventSize;
        this.contextKeySelectors = builder.contextKeySelectors;
        this.aggregationConfigurations = builder.aggregationConfigurations;
    }

    public final String trailARN() {
        return this.trailARN;
    }

    public final String eventDataStoreArn() {
        return this.eventDataStoreArn;
    }

    public final MaxEventSize maxEventSize() {
        return MaxEventSize.fromValue(this.maxEventSize);
    }

    public final String maxEventSizeAsString() {
        return this.maxEventSize;
    }

    public final boolean hasContextKeySelectors() {
        return this.contextKeySelectors != null && !(this.contextKeySelectors instanceof SdkAutoConstructList);
    }

    public final List<ContextKeySelector> contextKeySelectors() {
        return this.contextKeySelectors;
    }

    public final boolean hasAggregationConfigurations() {
        return this.aggregationConfigurations != null && !(this.aggregationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<AggregationConfiguration> aggregationConfigurations() {
        return this.aggregationConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trailARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxEventSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContextKeySelectors() ? this.contextKeySelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregationConfigurations() ? this.aggregationConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventConfigurationResponse)) {
            return false;
        }
        PutEventConfigurationResponse other = (PutEventConfigurationResponse)((Object)obj);
        return Objects.equals(this.trailARN(), other.trailARN()) && Objects.equals(this.eventDataStoreArn(), other.eventDataStoreArn()) && Objects.equals(this.maxEventSizeAsString(), other.maxEventSizeAsString()) && this.hasContextKeySelectors() == other.hasContextKeySelectors() && Objects.equals(this.contextKeySelectors(), other.contextKeySelectors()) && this.hasAggregationConfigurations() == other.hasAggregationConfigurations() && Objects.equals(this.aggregationConfigurations(), other.aggregationConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"PutEventConfigurationResponse").add("TrailARN", (Object)this.trailARN()).add("EventDataStoreArn", (Object)this.eventDataStoreArn()).add("MaxEventSize", (Object)this.maxEventSizeAsString()).add("ContextKeySelectors", this.hasContextKeySelectors() ? this.contextKeySelectors() : null).add("AggregationConfigurations", this.hasAggregationConfigurations() ? this.aggregationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrailARN": {
                return Optional.ofNullable(clazz.cast(this.trailARN()));
            }
            case "EventDataStoreArn": {
                return Optional.ofNullable(clazz.cast(this.eventDataStoreArn()));
            }
            case "MaxEventSize": {
                return Optional.ofNullable(clazz.cast(this.maxEventSizeAsString()));
            }
            case "ContextKeySelectors": {
                return Optional.ofNullable(clazz.cast(this.contextKeySelectors()));
            }
            case "AggregationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.aggregationConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrailARN", TRAIL_ARN_FIELD);
        map.put("EventDataStoreArn", EVENT_DATA_STORE_ARN_FIELD);
        map.put("MaxEventSize", MAX_EVENT_SIZE_FIELD);
        map.put("ContextKeySelectors", CONTEXT_KEY_SELECTORS_FIELD);
        map.put("AggregationConfigurations", AGGREGATION_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutEventConfigurationResponse, T> g) {
        return obj -> g.apply((PutEventConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private String trailARN;
        private String eventDataStoreArn;
        private String maxEventSize;
        private List<ContextKeySelector> contextKeySelectors = DefaultSdkAutoConstructList.getInstance();
        private List<AggregationConfiguration> aggregationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventConfigurationResponse model) {
            super(model);
            this.trailARN(model.trailARN);
            this.eventDataStoreArn(model.eventDataStoreArn);
            this.maxEventSize(model.maxEventSize);
            this.contextKeySelectors(model.contextKeySelectors);
            this.aggregationConfigurations(model.aggregationConfigurations);
        }

        public final String getTrailARN() {
            return this.trailARN;
        }

        public final void setTrailARN(String trailARN) {
            this.trailARN = trailARN;
        }

        @Override
        public final Builder trailARN(String trailARN) {
            this.trailARN = trailARN;
            return this;
        }

        public final String getEventDataStoreArn() {
            return this.eventDataStoreArn;
        }

        public final void setEventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
        }

        @Override
        public final Builder eventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
            return this;
        }

        public final String getMaxEventSize() {
            return this.maxEventSize;
        }

        public final void setMaxEventSize(String maxEventSize) {
            this.maxEventSize = maxEventSize;
        }

        @Override
        public final Builder maxEventSize(String maxEventSize) {
            this.maxEventSize = maxEventSize;
            return this;
        }

        @Override
        public final Builder maxEventSize(MaxEventSize maxEventSize) {
            this.maxEventSize(maxEventSize == null ? null : maxEventSize.toString());
            return this;
        }

        public final List<ContextKeySelector.Builder> getContextKeySelectors() {
            List<ContextKeySelector.Builder> result = ContextKeySelectorsCopier.copyToBuilder(this.contextKeySelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContextKeySelectors(Collection<ContextKeySelector.BuilderImpl> contextKeySelectors) {
            this.contextKeySelectors = ContextKeySelectorsCopier.copyFromBuilder(contextKeySelectors);
        }

        @Override
        public final Builder contextKeySelectors(Collection<ContextKeySelector> contextKeySelectors) {
            this.contextKeySelectors = ContextKeySelectorsCopier.copy(contextKeySelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextKeySelectors(ContextKeySelector ... contextKeySelectors) {
            this.contextKeySelectors(Arrays.asList(contextKeySelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextKeySelectors(Consumer<ContextKeySelector.Builder> ... contextKeySelectors) {
            this.contextKeySelectors(Stream.of(contextKeySelectors).map(c -> (ContextKeySelector)((ContextKeySelector.Builder)ContextKeySelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AggregationConfiguration.Builder> getAggregationConfigurations() {
            List<AggregationConfiguration.Builder> result = AggregationConfigurationsCopier.copyToBuilder(this.aggregationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregationConfigurations(Collection<AggregationConfiguration.BuilderImpl> aggregationConfigurations) {
            this.aggregationConfigurations = AggregationConfigurationsCopier.copyFromBuilder(aggregationConfigurations);
        }

        @Override
        public final Builder aggregationConfigurations(Collection<AggregationConfiguration> aggregationConfigurations) {
            this.aggregationConfigurations = AggregationConfigurationsCopier.copy(aggregationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationConfigurations(AggregationConfiguration ... aggregationConfigurations) {
            this.aggregationConfigurations(Arrays.asList(aggregationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationConfigurations(Consumer<AggregationConfiguration.Builder> ... aggregationConfigurations) {
            this.aggregationConfigurations(Stream.of(aggregationConfigurations).map(c -> (AggregationConfiguration)((AggregationConfiguration.Builder)AggregationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutEventConfigurationResponse build() {
            return new PutEventConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutEventConfigurationResponse> {
        public Builder trailARN(String var1);

        public Builder eventDataStoreArn(String var1);

        public Builder maxEventSize(String var1);

        public Builder maxEventSize(MaxEventSize var1);

        public Builder contextKeySelectors(Collection<ContextKeySelector> var1);

        public Builder contextKeySelectors(ContextKeySelector ... var1);

        public Builder contextKeySelectors(Consumer<ContextKeySelector.Builder> ... var1);

        public Builder aggregationConfigurations(Collection<AggregationConfiguration> var1);

        public Builder aggregationConfigurations(AggregationConfiguration ... var1);

        public Builder aggregationConfigurations(Consumer<AggregationConfiguration.Builder> ... var1);
    }
}

