/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtraildata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuditEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuditEvent> {
    private static final SdkField<String> EVENT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventData").getter(AuditEvent.getter(AuditEvent::eventData)).setter(AuditEvent.setter(Builder::eventData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventData").build()}).build();
    private static final SdkField<String> EVENT_DATA_CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventDataChecksum").getter(AuditEvent.getter(AuditEvent::eventDataChecksum)).setter(AuditEvent.setter(Builder::eventDataChecksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventDataChecksum").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AuditEvent.getter(AuditEvent::id)).setter(AuditEvent.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_FIELD, EVENT_DATA_CHECKSUM_FIELD, ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuditEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eventData;
    private final String eventDataChecksum;
    private final String id;

    private AuditEvent(BuilderImpl builder) {
        this.eventData = builder.eventData;
        this.eventDataChecksum = builder.eventDataChecksum;
        this.id = builder.id;
    }

    public final String eventData() {
        return this.eventData;
    }

    public final String eventDataChecksum() {
        return this.eventDataChecksum;
    }

    public final String id() {
        return this.id;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventData());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditEvent)) {
            return false;
        }
        AuditEvent other = (AuditEvent)obj;
        return Objects.equals(this.eventData(), other.eventData()) && Objects.equals(this.eventDataChecksum(), other.eventDataChecksum()) && Objects.equals(this.id(), other.id());
    }

    public final String toString() {
        return ToString.builder((String)"AuditEvent").add("EventData", (Object)this.eventData()).add("EventDataChecksum", (Object)this.eventDataChecksum()).add("Id", (Object)this.id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventData": {
                return Optional.ofNullable(clazz.cast(this.eventData()));
            }
            case "eventDataChecksum": {
                return Optional.ofNullable(clazz.cast(this.eventDataChecksum()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("eventData", EVENT_DATA_FIELD);
        map.put("eventDataChecksum", EVENT_DATA_CHECKSUM_FIELD);
        map.put("id", ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuditEvent, T> g) {
        return obj -> g.apply((AuditEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventData;
        private String eventDataChecksum;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditEvent model) {
            this.eventData(model.eventData);
            this.eventDataChecksum(model.eventDataChecksum);
            this.id(model.id);
        }

        public final String getEventData() {
            return this.eventData;
        }

        public final void setEventData(String eventData) {
            this.eventData = eventData;
        }

        @Override
        public final Builder eventData(String eventData) {
            this.eventData = eventData;
            return this;
        }

        public final String getEventDataChecksum() {
            return this.eventDataChecksum;
        }

        public final void setEventDataChecksum(String eventDataChecksum) {
            this.eventDataChecksum = eventDataChecksum;
        }

        @Override
        public final Builder eventDataChecksum(String eventDataChecksum) {
            this.eventDataChecksum = eventDataChecksum;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public AuditEvent build() {
            return new AuditEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuditEvent> {
        public Builder eventData(String var1);

        public Builder eventDataChecksum(String var1);

        public Builder id(String var1);
    }
}

