/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.publishers.cloudwatch.internal.transform;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.metrics.SdkMetric;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.transform.MetricAggregator;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.transform.MetricAggregatorKey;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;

@SdkInternalApi
class DetailedMetricAggregator
implements MetricAggregator {
    private final SdkMetric<?> metric;
    private final List<Dimension> dimensions;
    private final StandardUnit unit;
    private final Map<Double, DetailedMetrics> metricDetails = new HashMap<Double, DetailedMetrics>();

    DetailedMetricAggregator(MetricAggregatorKey key, StandardUnit unit) {
        this.metric = key.metric();
        this.dimensions = key.dimensions();
        this.unit = unit;
    }

    @Override
    public SdkMetric<?> metric() {
        return this.metric;
    }

    @Override
    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    @Override
    public void addMetricValue(double value) {
        this.metricDetails.computeIfAbsent(value, v -> new DetailedMetrics(value)).metricCount++;
    }

    @Override
    public StandardUnit unit() {
        return this.unit;
    }

    public Collection<DetailedMetrics> detailedMetrics() {
        return Collections.unmodifiableCollection(this.metricDetails.values());
    }

    public static class DetailedMetrics {
        private final double metricValue;
        private int metricCount = 0;

        private DetailedMetrics(double metricValue) {
            this.metricValue = metricValue;
        }

        public double metricValue() {
            return this.metricValue;
        }

        public int metricCount() {
            return this.metricCount;
        }
    }
}

