/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DestinationConfiguration;
import software.amazon.awssdk.services.cloudwatchlogs.model.QueryLanguage;
import software.amazon.awssdk.services.cloudwatchlogs.model.ScheduledQueryLogGroupIdentifiersCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.ScheduledQueryState;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateScheduledQueryRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, CreateScheduledQueryRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::name)).setter(CreateScheduledQueryRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::description)).setter(CreateScheduledQueryRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> QUERY_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryLanguage").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::queryLanguageAsString)).setter(CreateScheduledQueryRequest.setter(Builder::queryLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryLanguage").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryString").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::queryString)).setter(CreateScheduledQueryRequest.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()}).build();
    private static final SdkField<List<String>> LOG_GROUP_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logGroupIdentifiers").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::logGroupIdentifiers)).setter(CreateScheduledQueryRequest.setter(Builder::logGroupIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scheduleExpression").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::scheduleExpression)).setter(CreateScheduledQueryRequest.setter(Builder::scheduleExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleExpression").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timezone").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::timezone)).setter(CreateScheduledQueryRequest.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timezone").build()}).build();
    private static final SdkField<Long> START_TIME_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("startTimeOffset").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::startTimeOffset)).setter(CreateScheduledQueryRequest.setter(Builder::startTimeOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeOffset").build()}).build();
    private static final SdkField<DestinationConfiguration> DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationConfiguration").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::destinationConfiguration)).setter(CreateScheduledQueryRequest.setter(Builder::destinationConfiguration)).constructor(DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfiguration").build()}).build();
    private static final SdkField<Long> SCHEDULE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("scheduleStartTime").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::scheduleStartTime)).setter(CreateScheduledQueryRequest.setter(Builder::scheduleStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleStartTime").build()}).build();
    private static final SdkField<Long> SCHEDULE_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("scheduleEndTime").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::scheduleEndTime)).setter(CreateScheduledQueryRequest.setter(Builder::scheduleEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleEndTime").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::executionRoleArn)).setter(CreateScheduledQueryRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::stateAsString)).setter(CreateScheduledQueryRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateScheduledQueryRequest.getter(CreateScheduledQueryRequest::tags)).setter(CreateScheduledQueryRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, QUERY_LANGUAGE_FIELD, QUERY_STRING_FIELD, LOG_GROUP_IDENTIFIERS_FIELD, SCHEDULE_EXPRESSION_FIELD, TIMEZONE_FIELD, START_TIME_OFFSET_FIELD, DESTINATION_CONFIGURATION_FIELD, SCHEDULE_START_TIME_FIELD, SCHEDULE_END_TIME_FIELD, EXECUTION_ROLE_ARN_FIELD, STATE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateScheduledQueryRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String queryLanguage;
    private final String queryString;
    private final List<String> logGroupIdentifiers;
    private final String scheduleExpression;
    private final String timezone;
    private final Long startTimeOffset;
    private final DestinationConfiguration destinationConfiguration;
    private final Long scheduleStartTime;
    private final Long scheduleEndTime;
    private final String executionRoleArn;
    private final String state;
    private final Map<String, String> tags;

    private CreateScheduledQueryRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.queryLanguage = builder.queryLanguage;
        this.queryString = builder.queryString;
        this.logGroupIdentifiers = builder.logGroupIdentifiers;
        this.scheduleExpression = builder.scheduleExpression;
        this.timezone = builder.timezone;
        this.startTimeOffset = builder.startTimeOffset;
        this.destinationConfiguration = builder.destinationConfiguration;
        this.scheduleStartTime = builder.scheduleStartTime;
        this.scheduleEndTime = builder.scheduleEndTime;
        this.executionRoleArn = builder.executionRoleArn;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final QueryLanguage queryLanguage() {
        return QueryLanguage.fromValue(this.queryLanguage);
    }

    public final String queryLanguageAsString() {
        return this.queryLanguage;
    }

    public final String queryString() {
        return this.queryString;
    }

    public final boolean hasLogGroupIdentifiers() {
        return this.logGroupIdentifiers != null && !(this.logGroupIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> logGroupIdentifiers() {
        return this.logGroupIdentifiers;
    }

    public final String scheduleExpression() {
        return this.scheduleExpression;
    }

    public final String timezone() {
        return this.timezone;
    }

    public final Long startTimeOffset() {
        return this.startTimeOffset;
    }

    public final DestinationConfiguration destinationConfiguration() {
        return this.destinationConfiguration;
    }

    public final Long scheduleStartTime() {
        return this.scheduleStartTime;
    }

    public final Long scheduleEndTime() {
        return this.scheduleEndTime;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final ScheduledQueryState state() {
        return ScheduledQueryState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogGroupIdentifiers() ? this.logGroupIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScheduledQueryRequest)) {
            return false;
        }
        CreateScheduledQueryRequest other = (CreateScheduledQueryRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.queryLanguageAsString(), other.queryLanguageAsString()) && Objects.equals(this.queryString(), other.queryString()) && this.hasLogGroupIdentifiers() == other.hasLogGroupIdentifiers() && Objects.equals(this.logGroupIdentifiers(), other.logGroupIdentifiers()) && Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.startTimeOffset(), other.startTimeOffset()) && Objects.equals(this.destinationConfiguration(), other.destinationConfiguration()) && Objects.equals(this.scheduleStartTime(), other.scheduleStartTime()) && Objects.equals(this.scheduleEndTime(), other.scheduleEndTime()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateScheduledQueryRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("QueryLanguage", (Object)this.queryLanguageAsString()).add("QueryString", (Object)this.queryString()).add("LogGroupIdentifiers", this.hasLogGroupIdentifiers() ? this.logGroupIdentifiers() : null).add("ScheduleExpression", (Object)this.scheduleExpression()).add("Timezone", (Object)this.timezone()).add("StartTimeOffset", (Object)this.startTimeOffset()).add("DestinationConfiguration", (Object)this.destinationConfiguration()).add("ScheduleStartTime", (Object)this.scheduleStartTime()).add("ScheduleEndTime", (Object)this.scheduleEndTime()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "queryLanguage": {
                return Optional.ofNullable(clazz.cast(this.queryLanguageAsString()));
            }
            case "queryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "logGroupIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.logGroupIdentifiers()));
            }
            case "scheduleExpression": {
                return Optional.ofNullable(clazz.cast(this.scheduleExpression()));
            }
            case "timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "startTimeOffset": {
                return Optional.ofNullable(clazz.cast(this.startTimeOffset()));
            }
            case "destinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.destinationConfiguration()));
            }
            case "scheduleStartTime": {
                return Optional.ofNullable(clazz.cast(this.scheduleStartTime()));
            }
            case "scheduleEndTime": {
                return Optional.ofNullable(clazz.cast(this.scheduleEndTime()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("queryLanguage", QUERY_LANGUAGE_FIELD);
        map.put("queryString", QUERY_STRING_FIELD);
        map.put("logGroupIdentifiers", LOG_GROUP_IDENTIFIERS_FIELD);
        map.put("scheduleExpression", SCHEDULE_EXPRESSION_FIELD);
        map.put("timezone", TIMEZONE_FIELD);
        map.put("startTimeOffset", START_TIME_OFFSET_FIELD);
        map.put("destinationConfiguration", DESTINATION_CONFIGURATION_FIELD);
        map.put("scheduleStartTime", SCHEDULE_START_TIME_FIELD);
        map.put("scheduleEndTime", SCHEDULE_END_TIME_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("state", STATE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateScheduledQueryRequest, T> g) {
        return obj -> g.apply((CreateScheduledQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String queryLanguage;
        private String queryString;
        private List<String> logGroupIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String scheduleExpression;
        private String timezone;
        private Long startTimeOffset;
        private DestinationConfiguration destinationConfiguration;
        private Long scheduleStartTime;
        private Long scheduleEndTime;
        private String executionRoleArn;
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScheduledQueryRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.queryLanguage(model.queryLanguage);
            this.queryString(model.queryString);
            this.logGroupIdentifiers(model.logGroupIdentifiers);
            this.scheduleExpression(model.scheduleExpression);
            this.timezone(model.timezone);
            this.startTimeOffset(model.startTimeOffset);
            this.destinationConfiguration(model.destinationConfiguration);
            this.scheduleStartTime(model.scheduleStartTime);
            this.scheduleEndTime(model.scheduleEndTime);
            this.executionRoleArn(model.executionRoleArn);
            this.state(model.state);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getQueryLanguage() {
            return this.queryLanguage;
        }

        public final void setQueryLanguage(String queryLanguage) {
            this.queryLanguage = queryLanguage;
        }

        @Override
        public final Builder queryLanguage(String queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        @Override
        public final Builder queryLanguage(QueryLanguage queryLanguage) {
            this.queryLanguage(queryLanguage == null ? null : queryLanguage.toString());
            return this;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Collection<String> getLogGroupIdentifiers() {
            if (this.logGroupIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logGroupIdentifiers;
        }

        public final void setLogGroupIdentifiers(Collection<String> logGroupIdentifiers) {
            this.logGroupIdentifiers = ScheduledQueryLogGroupIdentifiersCopier.copy(logGroupIdentifiers);
        }

        @Override
        public final Builder logGroupIdentifiers(Collection<String> logGroupIdentifiers) {
            this.logGroupIdentifiers = ScheduledQueryLogGroupIdentifiersCopier.copy(logGroupIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupIdentifiers(String ... logGroupIdentifiers) {
            this.logGroupIdentifiers(Arrays.asList(logGroupIdentifiers));
            return this;
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final Long getStartTimeOffset() {
            return this.startTimeOffset;
        }

        public final void setStartTimeOffset(Long startTimeOffset) {
            this.startTimeOffset = startTimeOffset;
        }

        @Override
        public final Builder startTimeOffset(Long startTimeOffset) {
            this.startTimeOffset = startTimeOffset;
            return this;
        }

        public final DestinationConfiguration.Builder getDestinationConfiguration() {
            return this.destinationConfiguration != null ? this.destinationConfiguration.toBuilder() : null;
        }

        public final void setDestinationConfiguration(DestinationConfiguration.BuilderImpl destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration != null ? destinationConfiguration.build() : null;
        }

        @Override
        public final Builder destinationConfiguration(DestinationConfiguration destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        public final Long getScheduleStartTime() {
            return this.scheduleStartTime;
        }

        public final void setScheduleStartTime(Long scheduleStartTime) {
            this.scheduleStartTime = scheduleStartTime;
        }

        @Override
        public final Builder scheduleStartTime(Long scheduleStartTime) {
            this.scheduleStartTime = scheduleStartTime;
            return this;
        }

        public final Long getScheduleEndTime() {
            return this.scheduleEndTime;
        }

        public final void setScheduleEndTime(Long scheduleEndTime) {
            this.scheduleEndTime = scheduleEndTime;
        }

        @Override
        public final Builder scheduleEndTime(Long scheduleEndTime) {
            this.scheduleEndTime = scheduleEndTime;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduledQueryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateScheduledQueryRequest build() {
            return new CreateScheduledQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateScheduledQueryRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder queryLanguage(String var1);

        public Builder queryLanguage(QueryLanguage var1);

        public Builder queryString(String var1);

        public Builder logGroupIdentifiers(Collection<String> var1);

        public Builder logGroupIdentifiers(String ... var1);

        public Builder scheduleExpression(String var1);

        public Builder timezone(String var1);

        public Builder startTimeOffset(Long var1);

        public Builder destinationConfiguration(DestinationConfiguration var1);

        default public Builder destinationConfiguration(Consumer<DestinationConfiguration.Builder> destinationConfiguration) {
            return this.destinationConfiguration((DestinationConfiguration)((DestinationConfiguration.Builder)DestinationConfiguration.builder().applyMutation(destinationConfiguration)).build());
        }

        public Builder scheduleStartTime(Long var1);

        public Builder scheduleEndTime(Long var1);

        public Builder executionRoleArn(String var1);

        public Builder state(String var1);

        public Builder state(ScheduledQueryState var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

