/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IndexType {
    FACET("FACET"),
    FIELD_INDEX("FIELD_INDEX"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IndexType> VALUE_MAP;
    private final String value;

    private IndexType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IndexType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IndexType> knownValues() {
        EnumSet<IndexType> knownValues = EnumSet.allOf(IndexType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IndexType.class, IndexType::toString);
    }
}

