/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutIndexPolicyRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, PutIndexPolicyRequest> {
    private static final SdkField<String> LOG_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupIdentifier").getter(PutIndexPolicyRequest.getter(PutIndexPolicyRequest::logGroupIdentifier)).setter(PutIndexPolicyRequest.setter(Builder::logGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifier").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyDocument").getter(PutIndexPolicyRequest.getter(PutIndexPolicyRequest::policyDocument)).setter(PutIndexPolicyRequest.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_IDENTIFIER_FIELD, POLICY_DOCUMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutIndexPolicyRequest.memberNameToFieldInitializer();
    private final String logGroupIdentifier;
    private final String policyDocument;

    private PutIndexPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupIdentifier = builder.logGroupIdentifier;
        this.policyDocument = builder.policyDocument;
    }

    public final String logGroupIdentifier() {
        return this.logGroupIdentifier;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIndexPolicyRequest)) {
            return false;
        }
        PutIndexPolicyRequest other = (PutIndexPolicyRequest)((Object)obj);
        return Objects.equals(this.logGroupIdentifier(), other.logGroupIdentifier()) && Objects.equals(this.policyDocument(), other.policyDocument());
    }

    public final String toString() {
        return ToString.builder((String)"PutIndexPolicyRequest").add("LogGroupIdentifier", (Object)this.logGroupIdentifier()).add("PolicyDocument", (Object)this.policyDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.logGroupIdentifier()));
            }
            case "policyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("logGroupIdentifier", LOG_GROUP_IDENTIFIER_FIELD);
        map.put("policyDocument", POLICY_DOCUMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutIndexPolicyRequest, T> g) {
        return obj -> g.apply((PutIndexPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String logGroupIdentifier;
        private String policyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(PutIndexPolicyRequest model) {
            super(model);
            this.logGroupIdentifier(model.logGroupIdentifier);
            this.policyDocument(model.policyDocument);
        }

        public final String getLogGroupIdentifier() {
            return this.logGroupIdentifier;
        }

        public final void setLogGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
        }

        @Override
        public final Builder logGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutIndexPolicyRequest build() {
            return new PutIndexPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutIndexPolicyRequest> {
        public Builder logGroupIdentifier(String var1);

        public Builder policyDocument(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

