/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.ActionStatus;
import software.amazon.awssdk.services.cloudwatchlogs.model.ScheduledQueryDestinationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledQueryDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledQueryDestination> {
    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationType").getter(ScheduledQueryDestination.getter(ScheduledQueryDestination::destinationTypeAsString)).setter(ScheduledQueryDestination.setter(Builder::destinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationType").build()}).build();
    private static final SdkField<String> DESTINATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationIdentifier").getter(ScheduledQueryDestination.getter(ScheduledQueryDestination::destinationIdentifier)).setter(ScheduledQueryDestination.setter(Builder::destinationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationIdentifier").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ScheduledQueryDestination.getter(ScheduledQueryDestination::statusAsString)).setter(ScheduledQueryDestination.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> PROCESSED_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("processedIdentifier").getter(ScheduledQueryDestination.getter(ScheduledQueryDestination::processedIdentifier)).setter(ScheduledQueryDestination.setter(Builder::processedIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processedIdentifier").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(ScheduledQueryDestination.getter(ScheduledQueryDestination::errorMessage)).setter(ScheduledQueryDestination.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_TYPE_FIELD, DESTINATION_IDENTIFIER_FIELD, STATUS_FIELD, PROCESSED_IDENTIFIER_FIELD, ERROR_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScheduledQueryDestination.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String destinationType;
    private final String destinationIdentifier;
    private final String status;
    private final String processedIdentifier;
    private final String errorMessage;

    private ScheduledQueryDestination(BuilderImpl builder) {
        this.destinationType = builder.destinationType;
        this.destinationIdentifier = builder.destinationIdentifier;
        this.status = builder.status;
        this.processedIdentifier = builder.processedIdentifier;
        this.errorMessage = builder.errorMessage;
    }

    public final ScheduledQueryDestinationType destinationType() {
        return ScheduledQueryDestinationType.fromValue(this.destinationType);
    }

    public final String destinationTypeAsString() {
        return this.destinationType;
    }

    public final String destinationIdentifier() {
        return this.destinationIdentifier;
    }

    public final ActionStatus status() {
        return ActionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String processedIdentifier() {
        return this.processedIdentifier;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.processedIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledQueryDestination)) {
            return false;
        }
        ScheduledQueryDestination other = (ScheduledQueryDestination)obj;
        return Objects.equals(this.destinationTypeAsString(), other.destinationTypeAsString()) && Objects.equals(this.destinationIdentifier(), other.destinationIdentifier()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.processedIdentifier(), other.processedIdentifier()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduledQueryDestination").add("DestinationType", (Object)this.destinationTypeAsString()).add("DestinationIdentifier", (Object)this.destinationIdentifier()).add("Status", (Object)this.statusAsString()).add("ProcessedIdentifier", (Object)this.processedIdentifier()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinationType": {
                return Optional.ofNullable(clazz.cast(this.destinationTypeAsString()));
            }
            case "destinationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.destinationIdentifier()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "processedIdentifier": {
                return Optional.ofNullable(clazz.cast(this.processedIdentifier()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("destinationType", DESTINATION_TYPE_FIELD);
        map.put("destinationIdentifier", DESTINATION_IDENTIFIER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("processedIdentifier", PROCESSED_IDENTIFIER_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledQueryDestination, T> g) {
        return obj -> g.apply((ScheduledQueryDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationType;
        private String destinationIdentifier;
        private String status;
        private String processedIdentifier;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledQueryDestination model) {
            this.destinationType(model.destinationType);
            this.destinationIdentifier(model.destinationIdentifier);
            this.status(model.status);
            this.processedIdentifier(model.processedIdentifier);
            this.errorMessage(model.errorMessage);
        }

        public final String getDestinationType() {
            return this.destinationType;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(ScheduledQueryDestinationType destinationType) {
            this.destinationType(destinationType == null ? null : destinationType.toString());
            return this;
        }

        public final String getDestinationIdentifier() {
            return this.destinationIdentifier;
        }

        public final void setDestinationIdentifier(String destinationIdentifier) {
            this.destinationIdentifier = destinationIdentifier;
        }

        @Override
        public final Builder destinationIdentifier(String destinationIdentifier) {
            this.destinationIdentifier = destinationIdentifier;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getProcessedIdentifier() {
            return this.processedIdentifier;
        }

        public final void setProcessedIdentifier(String processedIdentifier) {
            this.processedIdentifier = processedIdentifier;
        }

        @Override
        public final Builder processedIdentifier(String processedIdentifier) {
            this.processedIdentifier = processedIdentifier;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public ScheduledQueryDestination build() {
            return new ScheduledQueryDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledQueryDestination> {
        public Builder destinationType(String var1);

        public Builder destinationType(ScheduledQueryDestinationType var1);

        public Builder destinationIdentifier(String var1);

        public Builder status(String var1);

        public Builder status(ActionStatus var1);

        public Builder processedIdentifier(String var1);

        public Builder errorMessage(String var1);
    }
}

