/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListScheduledQueriesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListScheduledQueriesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ScheduledQuerySummary;

public class ListScheduledQueriesIterable
implements SdkIterable<ListScheduledQueriesResponse> {
    private final CloudWatchLogsClient client;
    private final ListScheduledQueriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListScheduledQueriesIterable(CloudWatchLogsClient client, ListScheduledQueriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListScheduledQueriesResponseFetcher();
    }

    public Iterator<ListScheduledQueriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScheduledQuerySummary> scheduledQueries() {
        Function<ListScheduledQueriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.scheduledQueries() != null) {
                return response.scheduledQueries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListScheduledQueriesResponseFetcher
    implements SyncPageFetcher<ListScheduledQueriesResponse> {
        private ListScheduledQueriesResponseFetcher() {
        }

        public boolean hasNextPage(ListScheduledQueriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListScheduledQueriesResponse nextPage(ListScheduledQueriesResponse previousPage) {
            if (previousPage == null) {
                return ListScheduledQueriesIterable.this.client.listScheduledQueries(ListScheduledQueriesIterable.this.firstRequest);
            }
            return ListScheduledQueriesIterable.this.client.listScheduledQueries((ListScheduledQueriesRequest)((Object)ListScheduledQueriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

