/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListSourcesForS3TableIntegrationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListSourcesForS3TableIntegrationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.S3TableIntegrationSource;

public class ListSourcesForS3TableIntegrationPublisher
implements SdkPublisher<ListSourcesForS3TableIntegrationResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final ListSourcesForS3TableIntegrationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSourcesForS3TableIntegrationPublisher(CloudWatchLogsAsyncClient client, ListSourcesForS3TableIntegrationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSourcesForS3TableIntegrationPublisher(CloudWatchLogsAsyncClient client, ListSourcesForS3TableIntegrationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSourcesForS3TableIntegrationResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSourcesForS3TableIntegrationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<S3TableIntegrationSource> sources() {
        Function<ListSourcesForS3TableIntegrationResponse, Iterator> getIterator = response -> {
            if (response != null && response.sources() != null) {
                return response.sources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSourcesForS3TableIntegrationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSourcesForS3TableIntegrationResponseFetcher
    implements AsyncPageFetcher<ListSourcesForS3TableIntegrationResponse> {
        private ListSourcesForS3TableIntegrationResponseFetcher() {
        }

        public boolean hasNextPage(ListSourcesForS3TableIntegrationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSourcesForS3TableIntegrationResponse> nextPage(ListSourcesForS3TableIntegrationResponse previousPage) {
            if (previousPage == null) {
                return ListSourcesForS3TableIntegrationPublisher.this.client.listSourcesForS3TableIntegration(ListSourcesForS3TableIntegrationPublisher.this.firstRequest);
            }
            return ListSourcesForS3TableIntegrationPublisher.this.client.listSourcesForS3TableIntegration((ListSourcesForS3TableIntegrationRequest)((Object)ListSourcesForS3TableIntegrationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

