/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssociatedPackagesRequest
extends CodeartifactRequest
implements ToCopyableBuilder<Builder, ListAssociatedPackagesRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(ListAssociatedPackagesRequest.getter(ListAssociatedPackagesRequest::domain)).setter(ListAssociatedPackagesRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()}).build();
    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainOwner").getter(ListAssociatedPackagesRequest.getter(ListAssociatedPackagesRequest::domainOwner)).setter(ListAssociatedPackagesRequest.setter(Builder::domainOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()}).build();
    private static final SdkField<String> PACKAGE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageGroup").getter(ListAssociatedPackagesRequest.getter(ListAssociatedPackagesRequest::packageGroup)).setter(ListAssociatedPackagesRequest.setter(Builder::packageGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("package-group").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAssociatedPackagesRequest.getter(ListAssociatedPackagesRequest::maxResults)).setter(ListAssociatedPackagesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssociatedPackagesRequest.getter(ListAssociatedPackagesRequest::nextToken)).setter(ListAssociatedPackagesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()}).build();
    private static final SdkField<Boolean> PREVIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("preview").getter(ListAssociatedPackagesRequest.getter(ListAssociatedPackagesRequest::preview)).setter(ListAssociatedPackagesRequest.setter(Builder::preview)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("preview").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, DOMAIN_OWNER_FIELD, PACKAGE_GROUP_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PREVIEW_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAssociatedPackagesRequest.memberNameToFieldInitializer();
    private final String domain;
    private final String domainOwner;
    private final String packageGroup;
    private final Integer maxResults;
    private final String nextToken;
    private final Boolean preview;

    private ListAssociatedPackagesRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.packageGroup = builder.packageGroup;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.preview = builder.preview;
    }

    public final String domain() {
        return this.domain;
    }

    public final String domainOwner() {
        return this.domainOwner;
    }

    public final String packageGroup() {
        return this.packageGroup;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Boolean preview() {
        return this.preview;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.preview());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociatedPackagesRequest)) {
            return false;
        }
        ListAssociatedPackagesRequest other = (ListAssociatedPackagesRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.domainOwner(), other.domainOwner()) && Objects.equals(this.packageGroup(), other.packageGroup()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.preview(), other.preview());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssociatedPackagesRequest").add("Domain", (Object)this.domain()).add("DomainOwner", (Object)this.domainOwner()).add("PackageGroup", (Object)this.packageGroup()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Preview", (Object)this.preview()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "domainOwner": {
                return Optional.ofNullable(clazz.cast(this.domainOwner()));
            }
            case "packageGroup": {
                return Optional.ofNullable(clazz.cast(this.packageGroup()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "preview": {
                return Optional.ofNullable(clazz.cast(this.preview()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domain", DOMAIN_FIELD);
        map.put("domain-owner", DOMAIN_OWNER_FIELD);
        map.put("package-group", PACKAGE_GROUP_FIELD);
        map.put("max-results", MAX_RESULTS_FIELD);
        map.put("next-token", NEXT_TOKEN_FIELD);
        map.put("preview", PREVIEW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAssociatedPackagesRequest, T> g) {
        return obj -> g.apply((ListAssociatedPackagesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactRequest.BuilderImpl
    implements Builder {
        private String domain;
        private String domainOwner;
        private String packageGroup;
        private Integer maxResults;
        private String nextToken;
        private Boolean preview;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociatedPackagesRequest model) {
            super(model);
            this.domain(model.domain);
            this.domainOwner(model.domainOwner);
            this.packageGroup(model.packageGroup);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.preview(model.preview);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainOwner() {
            return this.domainOwner;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final String getPackageGroup() {
            return this.packageGroup;
        }

        public final void setPackageGroup(String packageGroup) {
            this.packageGroup = packageGroup;
        }

        @Override
        public final Builder packageGroup(String packageGroup) {
            this.packageGroup = packageGroup;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getPreview() {
            return this.preview;
        }

        public final void setPreview(Boolean preview) {
            this.preview = preview;
        }

        @Override
        public final Builder preview(Boolean preview) {
            this.preview = preview;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssociatedPackagesRequest build() {
            return new ListAssociatedPackagesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeartifactRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssociatedPackagesRequest> {
        public Builder domain(String var1);

        public Builder domainOwner(String var1);

        public Builder packageGroup(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder preview(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

