/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.AllowPublish;
import software.amazon.awssdk.services.codeartifact.model.AllowUpstream;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageOriginRestrictions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageOriginRestrictions> {
    private static final SdkField<String> PUBLISH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("publish").getter(PackageOriginRestrictions.getter(PackageOriginRestrictions::publishAsString)).setter(PackageOriginRestrictions.setter(Builder::publish)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publish").build()}).build();
    private static final SdkField<String> UPSTREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("upstream").getter(PackageOriginRestrictions.getter(PackageOriginRestrictions::upstreamAsString)).setter(PackageOriginRestrictions.setter(Builder::upstream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstream").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLISH_FIELD, UPSTREAM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PackageOriginRestrictions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String publish;
    private final String upstream;

    private PackageOriginRestrictions(BuilderImpl builder) {
        this.publish = builder.publish;
        this.upstream = builder.upstream;
    }

    public final AllowPublish publish() {
        return AllowPublish.fromValue(this.publish);
    }

    public final String publishAsString() {
        return this.publish;
    }

    public final AllowUpstream upstream() {
        return AllowUpstream.fromValue(this.upstream);
    }

    public final String upstreamAsString() {
        return this.upstream;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.publishAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.upstreamAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageOriginRestrictions)) {
            return false;
        }
        PackageOriginRestrictions other = (PackageOriginRestrictions)obj;
        return Objects.equals(this.publishAsString(), other.publishAsString()) && Objects.equals(this.upstreamAsString(), other.upstreamAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PackageOriginRestrictions").add("Publish", (Object)this.publishAsString()).add("Upstream", (Object)this.upstreamAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "publish": {
                return Optional.ofNullable(clazz.cast(this.publishAsString()));
            }
            case "upstream": {
                return Optional.ofNullable(clazz.cast(this.upstreamAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("publish", PUBLISH_FIELD);
        map.put("upstream", UPSTREAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PackageOriginRestrictions, T> g) {
        return obj -> g.apply((PackageOriginRestrictions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String publish;
        private String upstream;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageOriginRestrictions model) {
            this.publish(model.publish);
            this.upstream(model.upstream);
        }

        public final String getPublish() {
            return this.publish;
        }

        public final void setPublish(String publish) {
            this.publish = publish;
        }

        @Override
        public final Builder publish(String publish) {
            this.publish = publish;
            return this;
        }

        @Override
        public final Builder publish(AllowPublish publish) {
            this.publish(publish == null ? null : publish.toString());
            return this;
        }

        public final String getUpstream() {
            return this.upstream;
        }

        public final void setUpstream(String upstream) {
            this.upstream = upstream;
        }

        @Override
        public final Builder upstream(String upstream) {
            this.upstream = upstream;
            return this;
        }

        @Override
        public final Builder upstream(AllowUpstream upstream) {
            this.upstream(upstream == null ? null : upstream.toString());
            return this;
        }

        public PackageOriginRestrictions build() {
            return new PackageOriginRestrictions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageOriginRestrictions> {
        public Builder publish(String var1);

        public Builder publish(AllowPublish var1);

        public Builder upstream(String var1);

        public Builder upstream(AllowUpstream var1);
    }
}

