/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeartifact.CodeartifactClient;
import software.amazon.awssdk.services.codeartifact.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsRequest;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageVersionSummary;

public class ListPackageVersionsIterable
implements SdkIterable<ListPackageVersionsResponse> {
    private final CodeartifactClient client;
    private final ListPackageVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPackageVersionsIterable(CodeartifactClient client, ListPackageVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPackageVersionsResponseFetcher();
    }

    public Iterator<ListPackageVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PackageVersionSummary> versions() {
        Function<ListPackageVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.versions() != null) {
                return response.versions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPackageVersionsResponseFetcher
    implements SyncPageFetcher<ListPackageVersionsResponse> {
        private ListPackageVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPackageVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPackageVersionsResponse nextPage(ListPackageVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListPackageVersionsIterable.this.client.listPackageVersions(ListPackageVersionsIterable.this.firstRequest);
            }
            return ListPackageVersionsIterable.this.client.listPackageVersions((ListPackageVersionsRequest)((Object)ListPackageVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

