/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecatalyst.model.UserType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserIdentity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserIdentity> {
    private static final SdkField<String> USER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userType").getter(UserIdentity.getter(UserIdentity::userTypeAsString)).setter(UserIdentity.setter(Builder::userType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userType").build()}).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalId").getter(UserIdentity.getter(UserIdentity::principalId)).setter(UserIdentity.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalId").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userName").getter(UserIdentity.getter(UserIdentity::userName)).setter(UserIdentity.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userName").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountId").getter(UserIdentity.getter(UserIdentity::awsAccountId)).setter(UserIdentity.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_TYPE_FIELD, PRINCIPAL_ID_FIELD, USER_NAME_FIELD, AWS_ACCOUNT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userType;
    private final String principalId;
    private final String userName;
    private final String awsAccountId;

    private UserIdentity(BuilderImpl builder) {
        this.userType = builder.userType;
        this.principalId = builder.principalId;
        this.userName = builder.userName;
        this.awsAccountId = builder.awsAccountId;
    }

    public final UserType userType() {
        return UserType.fromValue(this.userType);
    }

    public final String userTypeAsString() {
        return this.userType;
    }

    public final String principalId() {
        return this.principalId;
    }

    public final String userName() {
        return this.userName;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserIdentity)) {
            return false;
        }
        UserIdentity other = (UserIdentity)obj;
        return Objects.equals(this.userTypeAsString(), other.userTypeAsString()) && Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.awsAccountId(), other.awsAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"UserIdentity").add("UserType", (Object)this.userTypeAsString()).add("PrincipalId", (Object)this.principalId()).add("UserName", (Object)this.userName()).add("AwsAccountId", (Object)this.awsAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userType": {
                return Optional.ofNullable(clazz.cast(this.userTypeAsString()));
            }
            case "principalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "userName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserIdentity, T> g) {
        return obj -> g.apply((UserIdentity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userType;
        private String principalId;
        private String userName;
        private String awsAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(UserIdentity model) {
            this.userType(model.userType);
            this.principalId(model.principalId);
            this.userName(model.userName);
            this.awsAccountId(model.awsAccountId);
        }

        public final String getUserType() {
            return this.userType;
        }

        public final void setUserType(String userType) {
            this.userType = userType;
        }

        @Override
        public final Builder userType(String userType) {
            this.userType = userType;
            return this;
        }

        @Override
        public final Builder userType(UserType userType) {
            this.userType(userType == null ? null : userType.toString());
            return this;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public UserIdentity build() {
            return new UserIdentity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserIdentity> {
        public Builder userType(String var1);

        public Builder userType(UserType var1);

        public Builder principalId(String var1);

        public Builder userName(String var1);

        public Builder awsAccountId(String var1);
    }
}

