/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about errors in a BatchAssociateApprovalRuleTemplateWithRepositories operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAssociateApprovalRuleTemplateWithRepositoriesError
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<BatchAssociateApprovalRuleTemplateWithRepositoriesError.Builder, BatchAssociateApprovalRuleTemplateWithRepositoriesError> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(BatchAssociateApprovalRuleTemplateWithRepositoriesError::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(BatchAssociateApprovalRuleTemplateWithRepositoriesError::errorCode))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(BatchAssociateApprovalRuleTemplateWithRepositoriesError::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String repositoryName;

    private final String errorCode;

    private final String errorMessage;

    private BatchAssociateApprovalRuleTemplateWithRepositoriesError(BuilderImpl builder) {
        this.repositoryName = builder.repositoryName;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The name of the repository where the association was not made.
     * </p>
     * 
     * @return The name of the repository where the association was not made.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * An error code that specifies whether the repository name was not valid or not found.
     * </p>
     * 
     * @return An error code that specifies whether the repository name was not valid or not found.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * An error message that provides details about why the repository name was not found or not valid.
     * </p>
     * 
     * @return An error message that provides details about why the repository name was not found or not valid.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateApprovalRuleTemplateWithRepositoriesError)) {
            return false;
        }
        BatchAssociateApprovalRuleTemplateWithRepositoriesError other = (BatchAssociateApprovalRuleTemplateWithRepositoriesError) obj;
        return Objects.equals(repositoryName(), other.repositoryName()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAssociateApprovalRuleTemplateWithRepositoriesError")
                .add("RepositoryName", repositoryName()).add("ErrorCode", errorCode()).add("ErrorMessage", errorMessage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateApprovalRuleTemplateWithRepositoriesError, T> g) {
        return obj -> g.apply((BatchAssociateApprovalRuleTemplateWithRepositoriesError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchAssociateApprovalRuleTemplateWithRepositoriesError> {
        /**
         * <p>
         * The name of the repository where the association was not made.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository where the association was not made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * An error code that specifies whether the repository name was not valid or not found.
         * </p>
         * 
         * @param errorCode
         *        An error code that specifies whether the repository name was not valid or not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * An error message that provides details about why the repository name was not found or not valid.
         * </p>
         * 
         * @param errorMessage
         *        An error message that provides details about why the repository name was not found or not valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryName;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateApprovalRuleTemplateWithRepositoriesError model) {
            repositoryName(model.repositoryName);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public BatchAssociateApprovalRuleTemplateWithRepositoriesError build() {
            return new BatchAssociateApprovalRuleTemplateWithRepositoriesError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
