/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a get repository triggers operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRepositoryTriggersResponse extends CodeCommitResponse implements
        ToCopyableBuilder<GetRepositoryTriggersResponse.Builder, GetRepositoryTriggersResponse> {
    private static final SdkField<String> CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configurationId").getter(getter(GetRepositoryTriggersResponse::configurationId))
            .setter(setter(Builder::configurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationId").build()).build();

    private static final SdkField<List<RepositoryTrigger>> TRIGGERS_FIELD = SdkField
            .<List<RepositoryTrigger>> builder(MarshallingType.LIST)
            .memberName("triggers")
            .getter(getter(GetRepositoryTriggersResponse::triggers))
            .setter(setter(Builder::triggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RepositoryTrigger> builder(MarshallingType.SDK_POJO)
                                            .constructor(RepositoryTrigger::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ID_FIELD,
            TRIGGERS_FIELD));

    private final String configurationId;

    private final List<RepositoryTrigger> triggers;

    private GetRepositoryTriggersResponse(BuilderImpl builder) {
        super(builder);
        this.configurationId = builder.configurationId;
        this.triggers = builder.triggers;
    }

    /**
     * <p>
     * The system-generated unique ID for the trigger.
     * </p>
     * 
     * @return The system-generated unique ID for the trigger.
     */
    public final String configurationId() {
        return configurationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Triggers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTriggers() {
        return triggers != null && !(triggers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The JSON block of configuration information for each trigger.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTriggers} method.
     * </p>
     * 
     * @return The JSON block of configuration information for each trigger.
     */
    public final List<RepositoryTrigger> triggers() {
        return triggers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTriggers() ? triggers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRepositoryTriggersResponse)) {
            return false;
        }
        GetRepositoryTriggersResponse other = (GetRepositoryTriggersResponse) obj;
        return Objects.equals(configurationId(), other.configurationId()) && hasTriggers() == other.hasTriggers()
                && Objects.equals(triggers(), other.triggers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRepositoryTriggersResponse").add("ConfigurationId", configurationId())
                .add("Triggers", hasTriggers() ? triggers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configurationId":
            return Optional.ofNullable(clazz.cast(configurationId()));
        case "triggers":
            return Optional.ofNullable(clazz.cast(triggers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRepositoryTriggersResponse, T> g) {
        return obj -> g.apply((GetRepositoryTriggersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRepositoryTriggersResponse> {
        /**
         * <p>
         * The system-generated unique ID for the trigger.
         * </p>
         * 
         * @param configurationId
         *        The system-generated unique ID for the trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationId(String configurationId);

        /**
         * <p>
         * The JSON block of configuration information for each trigger.
         * </p>
         * 
         * @param triggers
         *        The JSON block of configuration information for each trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Collection<RepositoryTrigger> triggers);

        /**
         * <p>
         * The JSON block of configuration information for each trigger.
         * </p>
         * 
         * @param triggers
         *        The JSON block of configuration information for each trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(RepositoryTrigger... triggers);

        /**
         * <p>
         * The JSON block of configuration information for each trigger.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codecommit.model.RepositoryTrigger.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.codecommit.model.RepositoryTrigger#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codecommit.model.RepositoryTrigger.Builder#build()} is called
         * immediately and its result is passed to {@link #triggers(List<RepositoryTrigger>)}.
         * 
         * @param triggers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codecommit.model.RepositoryTrigger.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggers(java.util.Collection<RepositoryTrigger>)
         */
        Builder triggers(Consumer<RepositoryTrigger.Builder>... triggers);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private String configurationId;

        private List<RepositoryTrigger> triggers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRepositoryTriggersResponse model) {
            super(model);
            configurationId(model.configurationId);
            triggers(model.triggers);
        }

        public final String getConfigurationId() {
            return configurationId;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final List<RepositoryTrigger.Builder> getTriggers() {
            List<RepositoryTrigger.Builder> result = RepositoryTriggersListCopier.copyToBuilder(this.triggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggers(Collection<RepositoryTrigger.BuilderImpl> triggers) {
            this.triggers = RepositoryTriggersListCopier.copyFromBuilder(triggers);
        }

        @Override
        public final Builder triggers(Collection<RepositoryTrigger> triggers) {
            this.triggers = RepositoryTriggersListCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(RepositoryTrigger... triggers) {
            triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<RepositoryTrigger.Builder>... triggers) {
            triggers(Stream.of(triggers).map(c -> RepositoryTrigger.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetRepositoryTriggersResponse build() {
            return new GetRepositoryTriggersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
