/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitClient;
import software.amazon.awssdk.services.codecommit.internal.UserAgentUtils;
import software.amazon.awssdk.services.codecommit.model.GetCommentReactionsRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentReactionsResponse;

public class GetCommentReactionsIterable
implements SdkIterable<GetCommentReactionsResponse> {
    private final CodeCommitClient client;
    private final GetCommentReactionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCommentReactionsIterable(CodeCommitClient client, GetCommentReactionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetCommentReactionsResponseFetcher();
    }

    public Iterator<GetCommentReactionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetCommentReactionsResponseFetcher
    implements SyncPageFetcher<GetCommentReactionsResponse> {
        private GetCommentReactionsResponseFetcher() {
        }

        public boolean hasNextPage(GetCommentReactionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetCommentReactionsResponse nextPage(GetCommentReactionsResponse previousPage) {
            if (previousPage == null) {
                return GetCommentReactionsIterable.this.client.getCommentReactions(GetCommentReactionsIterable.this.firstRequest);
            }
            return GetCommentReactionsIterable.this.client.getCommentReactions((GetCommentReactionsRequest)((Object)GetCommentReactionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

