/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePullRequestApprovalRuleContentRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, UpdatePullRequestApprovalRuleContentRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pullRequestId").getter(UpdatePullRequestApprovalRuleContentRequest.getter(UpdatePullRequestApprovalRuleContentRequest::pullRequestId)).setter(UpdatePullRequestApprovalRuleContentRequest.setter(Builder::pullRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()}).build();
    private static final SdkField<String> APPROVAL_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("approvalRuleName").getter(UpdatePullRequestApprovalRuleContentRequest.getter(UpdatePullRequestApprovalRuleContentRequest::approvalRuleName)).setter(UpdatePullRequestApprovalRuleContentRequest.setter(Builder::approvalRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleName").build()}).build();
    private static final SdkField<String> EXISTING_RULE_CONTENT_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("existingRuleContentSha256").getter(UpdatePullRequestApprovalRuleContentRequest.getter(UpdatePullRequestApprovalRuleContentRequest::existingRuleContentSha256)).setter(UpdatePullRequestApprovalRuleContentRequest.setter(Builder::existingRuleContentSha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("existingRuleContentSha256").build()}).build();
    private static final SdkField<String> NEW_RULE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("newRuleContent").getter(UpdatePullRequestApprovalRuleContentRequest.getter(UpdatePullRequestApprovalRuleContentRequest::newRuleContent)).setter(UpdatePullRequestApprovalRuleContentRequest.setter(Builder::newRuleContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newRuleContent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD, APPROVAL_RULE_NAME_FIELD, EXISTING_RULE_CONTENT_SHA256_FIELD, NEW_RULE_CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePullRequestApprovalRuleContentRequest.memberNameToFieldInitializer();
    private final String pullRequestId;
    private final String approvalRuleName;
    private final String existingRuleContentSha256;
    private final String newRuleContent;

    private UpdatePullRequestApprovalRuleContentRequest(BuilderImpl builder) {
        super(builder);
        this.pullRequestId = builder.pullRequestId;
        this.approvalRuleName = builder.approvalRuleName;
        this.existingRuleContentSha256 = builder.existingRuleContentSha256;
        this.newRuleContent = builder.newRuleContent;
    }

    public final String pullRequestId() {
        return this.pullRequestId;
    }

    public final String approvalRuleName() {
        return this.approvalRuleName;
    }

    public final String existingRuleContentSha256() {
        return this.existingRuleContentSha256;
    }

    public final String newRuleContent() {
        return this.newRuleContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.existingRuleContentSha256());
        hashCode = 31 * hashCode + Objects.hashCode(this.newRuleContent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePullRequestApprovalRuleContentRequest)) {
            return false;
        }
        UpdatePullRequestApprovalRuleContentRequest other = (UpdatePullRequestApprovalRuleContentRequest)((Object)obj);
        return Objects.equals(this.pullRequestId(), other.pullRequestId()) && Objects.equals(this.approvalRuleName(), other.approvalRuleName()) && Objects.equals(this.existingRuleContentSha256(), other.existingRuleContentSha256()) && Objects.equals(this.newRuleContent(), other.newRuleContent());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePullRequestApprovalRuleContentRequest").add("PullRequestId", (Object)this.pullRequestId()).add("ApprovalRuleName", (Object)this.approvalRuleName()).add("ExistingRuleContentSha256", (Object)this.existingRuleContentSha256()).add("NewRuleContent", (Object)this.newRuleContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pullRequestId": {
                return Optional.ofNullable(clazz.cast(this.pullRequestId()));
            }
            case "approvalRuleName": {
                return Optional.ofNullable(clazz.cast(this.approvalRuleName()));
            }
            case "existingRuleContentSha256": {
                return Optional.ofNullable(clazz.cast(this.existingRuleContentSha256()));
            }
            case "newRuleContent": {
                return Optional.ofNullable(clazz.cast(this.newRuleContent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("pullRequestId", PULL_REQUEST_ID_FIELD);
        map.put("approvalRuleName", APPROVAL_RULE_NAME_FIELD);
        map.put("existingRuleContentSha256", EXISTING_RULE_CONTENT_SHA256_FIELD);
        map.put("newRuleContent", NEW_RULE_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePullRequestApprovalRuleContentRequest, T> g) {
        return obj -> g.apply((UpdatePullRequestApprovalRuleContentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String pullRequestId;
        private String approvalRuleName;
        private String existingRuleContentSha256;
        private String newRuleContent;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePullRequestApprovalRuleContentRequest model) {
            super(model);
            this.pullRequestId(model.pullRequestId);
            this.approvalRuleName(model.approvalRuleName);
            this.existingRuleContentSha256(model.existingRuleContentSha256);
            this.newRuleContent(model.newRuleContent);
        }

        public final String getPullRequestId() {
            return this.pullRequestId;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final String getApprovalRuleName() {
            return this.approvalRuleName;
        }

        public final void setApprovalRuleName(String approvalRuleName) {
            this.approvalRuleName = approvalRuleName;
        }

        @Override
        public final Builder approvalRuleName(String approvalRuleName) {
            this.approvalRuleName = approvalRuleName;
            return this;
        }

        public final String getExistingRuleContentSha256() {
            return this.existingRuleContentSha256;
        }

        public final void setExistingRuleContentSha256(String existingRuleContentSha256) {
            this.existingRuleContentSha256 = existingRuleContentSha256;
        }

        @Override
        public final Builder existingRuleContentSha256(String existingRuleContentSha256) {
            this.existingRuleContentSha256 = existingRuleContentSha256;
            return this;
        }

        public final String getNewRuleContent() {
            return this.newRuleContent;
        }

        public final void setNewRuleContent(String newRuleContent) {
            this.newRuleContent = newRuleContent;
        }

        @Override
        public final Builder newRuleContent(String newRuleContent) {
            this.newRuleContent = newRuleContent;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePullRequestApprovalRuleContentRequest build() {
            return new UpdatePullRequestApprovalRuleContentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePullRequestApprovalRuleContentRequest> {
        public Builder pullRequestId(String var1);

        public Builder approvalRuleName(String var1);

        public Builder existingRuleContentSha256(String var1);

        public Builder newRuleContent(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

