/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Notification medium for users to get alerted for events that occur in application profile. We support SNS topic as a
 * notification channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Channel implements SdkPojo, Serializable, ToCopyableBuilder<Channel.Builder, Channel> {
    private static final SdkField<List<String>> EVENT_PUBLISHERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eventPublishers")
            .getter(getter(Channel::eventPublishersAsStrings))
            .setter(setter(Builder::eventPublishersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventPublishers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Channel::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("uri")
            .getter(getter(Channel::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_PUBLISHERS_FIELD,
            ID_FIELD, URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> eventPublishers;

    private final String id;

    private final String uri;

    private Channel(BuilderImpl builder) {
        this.eventPublishers = builder.eventPublishers;
        this.id = builder.id;
        this.uri = builder.uri;
    }

    /**
     * <p>
     * List of publishers for different type of events that may be detected in an application from the profile. Anomaly
     * detection is the only event publisher in Profiler.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventPublishers} method.
     * </p>
     * 
     * @return List of publishers for different type of events that may be detected in an application from the profile.
     *         Anomaly detection is the only event publisher in Profiler.
     */
    public final List<EventPublisher> eventPublishers() {
        return EventPublishersCopier.copyStringToEnum(eventPublishers);
    }

    /**
     * For responses, this returns true if the service returned a value for the EventPublishers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventPublishers() {
        return eventPublishers != null && !(eventPublishers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of publishers for different type of events that may be detected in an application from the profile. Anomaly
     * detection is the only event publisher in Profiler.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventPublishers} method.
     * </p>
     * 
     * @return List of publishers for different type of events that may be detected in an application from the profile.
     *         Anomaly detection is the only event publisher in Profiler.
     */
    public final List<String> eventPublishersAsStrings() {
        return eventPublishers;
    }

    /**
     * <p>
     * Unique identifier for each <code>Channel</code> in the notification configuration of a Profiling Group. A random
     * UUID for channelId is used when adding a channel to the notification configuration if not specified in the
     * request.
     * </p>
     * 
     * @return Unique identifier for each <code>Channel</code> in the notification configuration of a Profiling Group. A
     *         random UUID for channelId is used when adding a channel to the notification configuration if not
     *         specified in the request.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Unique arn of the resource to be used for notifications. We support a valid SNS topic arn as a channel uri.
     * </p>
     * 
     * @return Unique arn of the resource to be used for notifications. We support a valid SNS topic arn as a channel
     *         uri.
     */
    public final String uri() {
        return uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEventPublishers() ? eventPublishersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel) obj;
        return hasEventPublishers() == other.hasEventPublishers()
                && Objects.equals(eventPublishersAsStrings(), other.eventPublishersAsStrings())
                && Objects.equals(id(), other.id()) && Objects.equals(uri(), other.uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Channel").add("EventPublishers", hasEventPublishers() ? eventPublishersAsStrings() : null)
                .add("Id", id()).add("Uri", uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventPublishers":
            return Optional.ofNullable(clazz.cast(eventPublishersAsStrings()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "uri":
            return Optional.ofNullable(clazz.cast(uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Channel, T> g) {
        return obj -> g.apply((Channel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Channel> {
        /**
         * <p>
         * List of publishers for different type of events that may be detected in an application from the profile.
         * Anomaly detection is the only event publisher in Profiler.
         * </p>
         * 
         * @param eventPublishers
         *        List of publishers for different type of events that may be detected in an application from the
         *        profile. Anomaly detection is the only event publisher in Profiler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventPublishersWithStrings(Collection<String> eventPublishers);

        /**
         * <p>
         * List of publishers for different type of events that may be detected in an application from the profile.
         * Anomaly detection is the only event publisher in Profiler.
         * </p>
         * 
         * @param eventPublishers
         *        List of publishers for different type of events that may be detected in an application from the
         *        profile. Anomaly detection is the only event publisher in Profiler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventPublishersWithStrings(String... eventPublishers);

        /**
         * <p>
         * List of publishers for different type of events that may be detected in an application from the profile.
         * Anomaly detection is the only event publisher in Profiler.
         * </p>
         * 
         * @param eventPublishers
         *        List of publishers for different type of events that may be detected in an application from the
         *        profile. Anomaly detection is the only event publisher in Profiler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventPublishers(Collection<EventPublisher> eventPublishers);

        /**
         * <p>
         * List of publishers for different type of events that may be detected in an application from the profile.
         * Anomaly detection is the only event publisher in Profiler.
         * </p>
         * 
         * @param eventPublishers
         *        List of publishers for different type of events that may be detected in an application from the
         *        profile. Anomaly detection is the only event publisher in Profiler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventPublishers(EventPublisher... eventPublishers);

        /**
         * <p>
         * Unique identifier for each <code>Channel</code> in the notification configuration of a Profiling Group. A
         * random UUID for channelId is used when adding a channel to the notification configuration if not specified in
         * the request.
         * </p>
         * 
         * @param id
         *        Unique identifier for each <code>Channel</code> in the notification configuration of a Profiling
         *        Group. A random UUID for channelId is used when adding a channel to the notification configuration if
         *        not specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Unique arn of the resource to be used for notifications. We support a valid SNS topic arn as a channel uri.
         * </p>
         * 
         * @param uri
         *        Unique arn of the resource to be used for notifications. We support a valid SNS topic arn as a channel
         *        uri.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);
    }

    static final class BuilderImpl implements Builder {
        private List<String> eventPublishers = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private String uri;

        private BuilderImpl() {
        }

        private BuilderImpl(Channel model) {
            eventPublishersWithStrings(model.eventPublishers);
            id(model.id);
            uri(model.uri);
        }

        public final Collection<String> getEventPublishers() {
            if (eventPublishers instanceof SdkAutoConstructList) {
                return null;
            }
            return eventPublishers;
        }

        public final void setEventPublishers(Collection<String> eventPublishers) {
            this.eventPublishers = EventPublishersCopier.copy(eventPublishers);
        }

        @Override
        public final Builder eventPublishersWithStrings(Collection<String> eventPublishers) {
            this.eventPublishers = EventPublishersCopier.copy(eventPublishers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventPublishersWithStrings(String... eventPublishers) {
            eventPublishersWithStrings(Arrays.asList(eventPublishers));
            return this;
        }

        @Override
        public final Builder eventPublishers(Collection<EventPublisher> eventPublishers) {
            this.eventPublishers = EventPublishersCopier.copyEnumToString(eventPublishers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventPublishers(EventPublisher... eventPublishers) {
            eventPublishers(Arrays.asList(eventPublishers));
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        @Override
        public Channel build() {
            return new Channel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
