/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codegurureviewer.model.CodeGuruReviewerResponse;
import software.amazon.awssdk.services.codegurureviewer.model.RepositoryAssociation;
import software.amazon.awssdk.services.codegurureviewer.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateRepositoryResponse
extends CodeGuruReviewerResponse
implements ToCopyableBuilder<Builder, DisassociateRepositoryResponse> {
    private static final SdkField<RepositoryAssociation> REPOSITORY_ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RepositoryAssociation").getter(DisassociateRepositoryResponse.getter(DisassociateRepositoryResponse::repositoryAssociation)).setter(DisassociateRepositoryResponse.setter(Builder::repositoryAssociation)).constructor(RepositoryAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryAssociation").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DisassociateRepositoryResponse.getter(DisassociateRepositoryResponse::tags)).setter(DisassociateRepositoryResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_ASSOCIATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisassociateRepositoryResponse.memberNameToFieldInitializer();
    private final RepositoryAssociation repositoryAssociation;
    private final Map<String, String> tags;

    private DisassociateRepositoryResponse(BuilderImpl builder) {
        super(builder);
        this.repositoryAssociation = builder.repositoryAssociation;
        this.tags = builder.tags;
    }

    public final RepositoryAssociation repositoryAssociation() {
        return this.repositoryAssociation;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateRepositoryResponse)) {
            return false;
        }
        DisassociateRepositoryResponse other = (DisassociateRepositoryResponse)((Object)obj);
        return Objects.equals(this.repositoryAssociation(), other.repositoryAssociation()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateRepositoryResponse").add("RepositoryAssociation", (Object)this.repositoryAssociation()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RepositoryAssociation": {
                return Optional.ofNullable(clazz.cast(this.repositoryAssociation()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RepositoryAssociation", REPOSITORY_ASSOCIATION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateRepositoryResponse, T> g) {
        return obj -> g.apply((DisassociateRepositoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruReviewerResponse.BuilderImpl
    implements Builder {
        private RepositoryAssociation repositoryAssociation;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateRepositoryResponse model) {
            super(model);
            this.repositoryAssociation(model.repositoryAssociation);
            this.tags(model.tags);
        }

        public final RepositoryAssociation.Builder getRepositoryAssociation() {
            return this.repositoryAssociation != null ? this.repositoryAssociation.toBuilder() : null;
        }

        public final void setRepositoryAssociation(RepositoryAssociation.BuilderImpl repositoryAssociation) {
            this.repositoryAssociation = repositoryAssociation != null ? repositoryAssociation.build() : null;
        }

        @Override
        public final Builder repositoryAssociation(RepositoryAssociation repositoryAssociation) {
            this.repositoryAssociation = repositoryAssociation;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public DisassociateRepositoryResponse build() {
            return new DisassociateRepositoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeGuruReviewerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateRepositoryResponse> {
        public Builder repositoryAssociation(RepositoryAssociation var1);

        default public Builder repositoryAssociation(Consumer<RepositoryAssociation.Builder> repositoryAssociation) {
            return this.repositoryAssociation((RepositoryAssociation)((RepositoryAssociation.Builder)RepositoryAssociation.builder().applyMutation(repositoryAssociation)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

