/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the error that caused a finding to fail to be retrieved.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetFindingsError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchGetFindingsError.Builder, BatchGetFindingsError> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(BatchGetFindingsError::errorCodeAsString)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> FINDING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("findingId").getter(getter(BatchGetFindingsError::findingId)).setter(setter(Builder::findingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingId").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(BatchGetFindingsError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> SCAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanName").getter(getter(BatchGetFindingsError::scanName)).setter(setter(Builder::scanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            FINDING_ID_FIELD, MESSAGE_FIELD, SCAN_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final String findingId;

    private final String message;

    private final String scanName;

    private BatchGetFindingsError(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.findingId = builder.findingId;
        this.message = builder.message;
        this.scanName = builder.scanName;
    }

    /**
     * <p>
     * A code associated with the type of error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link ErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return A code associated with the type of error.
     * @see ErrorCode
     */
    public final ErrorCode errorCode() {
        return ErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * A code associated with the type of error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link ErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return A code associated with the type of error.
     * @see ErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * The finding ID of the finding that was not fetched.
     * </p>
     * 
     * @return The finding ID of the finding that was not fetched.
     */
    public final String findingId() {
        return findingId;
    }

    /**
     * <p>
     * Describes the error.
     * </p>
     * 
     * @return Describes the error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The name of the scan that generated the finding.
     * </p>
     * 
     * @return The name of the scan that generated the finding.
     */
    public final String scanName() {
        return scanName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(findingId());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(scanName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFindingsError)) {
            return false;
        }
        BatchGetFindingsError other = (BatchGetFindingsError) obj;
        return Objects.equals(errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(findingId(), other.findingId())
                && Objects.equals(message(), other.message()) && Objects.equals(scanName(), other.scanName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetFindingsError").add("ErrorCode", errorCodeAsString()).add("FindingId", findingId())
                .add("Message", message()).add("ScanName", scanName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "findingId":
            return Optional.ofNullable(clazz.cast(findingId()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "scanName":
            return Optional.ofNullable(clazz.cast(scanName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFindingsError, T> g) {
        return obj -> g.apply((BatchGetFindingsError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchGetFindingsError> {
        /**
         * <p>
         * A code associated with the type of error.
         * </p>
         * 
         * @param errorCode
         *        A code associated with the type of error.
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * A code associated with the type of error.
         * </p>
         * 
         * @param errorCode
         *        A code associated with the type of error.
         * @see ErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCode
         */
        Builder errorCode(ErrorCode errorCode);

        /**
         * <p>
         * The finding ID of the finding that was not fetched.
         * </p>
         * 
         * @param findingId
         *        The finding ID of the finding that was not fetched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingId(String findingId);

        /**
         * <p>
         * Describes the error.
         * </p>
         * 
         * @param message
         *        Describes the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The name of the scan that generated the finding.
         * </p>
         * 
         * @param scanName
         *        The name of the scan that generated the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanName(String scanName);
    }

    static final class BuilderImpl implements Builder {
        private String errorCode;

        private String findingId;

        private String message;

        private String scanName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFindingsError model) {
            errorCode(model.errorCode);
            findingId(model.findingId);
            message(model.message);
            scanName(model.scanName);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getFindingId() {
            return findingId;
        }

        public final void setFindingId(String findingId) {
            this.findingId = findingId;
        }

        @Override
        public final Builder findingId(String findingId) {
            this.findingId = findingId;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getScanName() {
            return scanName;
        }

        public final void setScanName(String scanName) {
            this.scanName = scanName;
        }

        @Override
        public final Builder scanName(String scanName) {
            this.scanName = scanName;
            return this;
        }

        @Override
        public BatchGetFindingsError build() {
            return new BatchGetFindingsError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
