/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codegurusecurity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about a finding and the scan that generated it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingIdentifier.Builder, FindingIdentifier> {
    private static final SdkField<String> FINDING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("findingId").getter(getter(FindingIdentifier::findingId)).setter(setter(Builder::findingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingId").build()).build();

    private static final SdkField<String> SCAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanName").getter(getter(FindingIdentifier::scanName)).setter(setter(Builder::scanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_ID_FIELD,
            SCAN_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String findingId;

    private final String scanName;

    private FindingIdentifier(BuilderImpl builder) {
        this.findingId = builder.findingId;
        this.scanName = builder.scanName;
    }

    /**
     * <p>
     * The identifier for a finding.
     * </p>
     * 
     * @return The identifier for a finding.
     */
    public final String findingId() {
        return findingId;
    }

    /**
     * <p>
     * The name of the scan that generated the finding.
     * </p>
     * 
     * @return The name of the scan that generated the finding.
     */
    public final String scanName() {
        return scanName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(findingId());
        hashCode = 31 * hashCode + Objects.hashCode(scanName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingIdentifier)) {
            return false;
        }
        FindingIdentifier other = (FindingIdentifier) obj;
        return Objects.equals(findingId(), other.findingId()) && Objects.equals(scanName(), other.scanName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingIdentifier").add("FindingId", findingId()).add("ScanName", scanName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findingId":
            return Optional.ofNullable(clazz.cast(findingId()));
        case "scanName":
            return Optional.ofNullable(clazz.cast(scanName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindingIdentifier, T> g) {
        return obj -> g.apply((FindingIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingIdentifier> {
        /**
         * <p>
         * The identifier for a finding.
         * </p>
         * 
         * @param findingId
         *        The identifier for a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingId(String findingId);

        /**
         * <p>
         * The name of the scan that generated the finding.
         * </p>
         * 
         * @param scanName
         *        The name of the scan that generated the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanName(String scanName);
    }

    static final class BuilderImpl implements Builder {
        private String findingId;

        private String scanName;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingIdentifier model) {
            findingId(model.findingId);
            scanName(model.scanName);
        }

        public final String getFindingId() {
            return findingId;
        }

        public final void setFindingId(String findingId) {
            this.findingId = findingId;
        }

        @Override
        public final Builder findingId(String findingId) {
            this.findingId = findingId;
            return this;
        }

        public final String getScanName() {
            return scanName;
        }

        public final void setScanName(String scanName) {
            this.scanName = scanName;
        }

        @Override
        public final Builder scanName(String scanName) {
            this.scanName = scanName;
            return this;
        }

        @Override
        public FindingIdentifier build() {
            return new FindingIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
