/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.TargetFilter;
import software.amazon.awssdk.services.codepipeline.model.TargetFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeployActionExecutionTargetsRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, ListDeployActionExecutionTargetsRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineName").getter(ListDeployActionExecutionTargetsRequest.getter(ListDeployActionExecutionTargetsRequest::pipelineName)).setter(ListDeployActionExecutionTargetsRequest.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()}).build();
    private static final SdkField<String> ACTION_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionExecutionId").getter(ListDeployActionExecutionTargetsRequest.getter(ListDeployActionExecutionTargetsRequest::actionExecutionId)).setter(ListDeployActionExecutionTargetsRequest.setter(Builder::actionExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionExecutionId").build()}).build();
    private static final SdkField<List<TargetFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(ListDeployActionExecutionTargetsRequest.getter(ListDeployActionExecutionTargetsRequest::filters)).setter(ListDeployActionExecutionTargetsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListDeployActionExecutionTargetsRequest.getter(ListDeployActionExecutionTargetsRequest::maxResults)).setter(ListDeployActionExecutionTargetsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDeployActionExecutionTargetsRequest.getter(ListDeployActionExecutionTargetsRequest::nextToken)).setter(ListDeployActionExecutionTargetsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, ACTION_EXECUTION_ID_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDeployActionExecutionTargetsRequest.memberNameToFieldInitializer();
    private final String pipelineName;
    private final String actionExecutionId;
    private final List<TargetFilter> filters;
    private final Integer maxResults;
    private final String nextToken;

    private ListDeployActionExecutionTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.actionExecutionId = builder.actionExecutionId;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String pipelineName() {
        return this.pipelineName;
    }

    public final String actionExecutionId() {
        return this.actionExecutionId;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<TargetFilter> filters() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeployActionExecutionTargetsRequest)) {
            return false;
        }
        ListDeployActionExecutionTargetsRequest other = (ListDeployActionExecutionTargetsRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.actionExecutionId(), other.actionExecutionId()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDeployActionExecutionTargetsRequest").add("PipelineName", (Object)this.pipelineName()).add("ActionExecutionId", (Object)this.actionExecutionId()).add("Filters", this.hasFilters() ? this.filters() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "actionExecutionId": {
                return Optional.ofNullable(clazz.cast(this.actionExecutionId()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pipelineName", PIPELINE_NAME_FIELD);
        map.put("actionExecutionId", ACTION_EXECUTION_ID_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDeployActionExecutionTargetsRequest, T> g) {
        return obj -> g.apply((ListDeployActionExecutionTargetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private String pipelineName;
        private String actionExecutionId;
        private List<TargetFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeployActionExecutionTargetsRequest model) {
            super(model);
            this.pipelineName(model.pipelineName);
            this.actionExecutionId(model.actionExecutionId);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getActionExecutionId() {
            return this.actionExecutionId;
        }

        public final void setActionExecutionId(String actionExecutionId) {
            this.actionExecutionId = actionExecutionId;
        }

        @Override
        public final Builder actionExecutionId(String actionExecutionId) {
            this.actionExecutionId = actionExecutionId;
            return this;
        }

        public final List<TargetFilter.Builder> getFilters() {
            List<TargetFilter.Builder> result = TargetFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<TargetFilter.BuilderImpl> filters) {
            this.filters = TargetFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<TargetFilter> filters) {
            this.filters = TargetFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(TargetFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<TargetFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (TargetFilter)((TargetFilter.Builder)TargetFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeployActionExecutionTargetsRequest build() {
            return new ListDeployActionExecutionTargetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodePipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeployActionExecutionTargetsRequest> {
        public Builder pipelineName(String var1);

        public Builder actionExecutionId(String var1);

        public Builder filters(Collection<TargetFilter> var1);

        public Builder filters(TargetFilter ... var1);

        public Builder filters(Consumer<TargetFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

