/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestar.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteProjectRequest extends CodeStarRequest implements
        ToCopyableBuilder<DeleteProjectRequest.Builder, DeleteProjectRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(DeleteProjectRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken").getter(getter(DeleteProjectRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final SdkField<Boolean> DELETE_STACK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleteStack").getter(getter(DeleteProjectRequest::deleteStack)).setter(setter(Builder::deleteStack))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteStack").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, DELETE_STACK_FIELD));

    private final String id;

    private final String clientRequestToken;

    private final Boolean deleteStack;

    private DeleteProjectRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.clientRequestToken = builder.clientRequestToken;
        this.deleteStack = builder.deleteStack;
    }

    /**
     * <p>
     * The ID of the project to be deleted in AWS CodeStar.
     * </p>
     * 
     * @return The ID of the project to be deleted in AWS CodeStar.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A user- or system-generated token that identifies the entity that requested project deletion. This token can be
     * used to repeat the request.
     * </p>
     * 
     * @return A user- or system-generated token that identifies the entity that requested project deletion. This token
     *         can be used to repeat the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * Whether to send a delete request for the primary stack in AWS CloudFormation originally used to generate the
     * project and its resources. This option will delete all AWS resources for the project (except for any buckets in
     * Amazon S3) as well as deleting the project itself. Recommended for most use cases.
     * </p>
     * 
     * @return Whether to send a delete request for the primary stack in AWS CloudFormation originally used to generate
     *         the project and its resources. This option will delete all AWS resources for the project (except for any
     *         buckets in Amazon S3) as well as deleting the project itself. Recommended for most use cases.
     */
    public final Boolean deleteStack() {
        return deleteStack;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(deleteStack());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProjectRequest)) {
            return false;
        }
        DeleteProjectRequest other = (DeleteProjectRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(deleteStack(), other.deleteStack());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteProjectRequest").add("Id", id()).add("ClientRequestToken", clientRequestToken())
                .add("DeleteStack", deleteStack()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "deleteStack":
            return Optional.ofNullable(clazz.cast(deleteStack()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteProjectRequest, T> g) {
        return obj -> g.apply((DeleteProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeStarRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteProjectRequest> {
        /**
         * <p>
         * The ID of the project to be deleted in AWS CodeStar.
         * </p>
         * 
         * @param id
         *        The ID of the project to be deleted in AWS CodeStar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A user- or system-generated token that identifies the entity that requested project deletion. This token can
         * be used to repeat the request.
         * </p>
         * 
         * @param clientRequestToken
         *        A user- or system-generated token that identifies the entity that requested project deletion. This
         *        token can be used to repeat the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Whether to send a delete request for the primary stack in AWS CloudFormation originally used to generate the
         * project and its resources. This option will delete all AWS resources for the project (except for any buckets
         * in Amazon S3) as well as deleting the project itself. Recommended for most use cases.
         * </p>
         * 
         * @param deleteStack
         *        Whether to send a delete request for the primary stack in AWS CloudFormation originally used to
         *        generate the project and its resources. This option will delete all AWS resources for the project
         *        (except for any buckets in Amazon S3) as well as deleting the project itself. Recommended for most use
         *        cases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteStack(Boolean deleteStack);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeStarRequest.BuilderImpl implements Builder {
        private String id;

        private String clientRequestToken;

        private Boolean deleteStack;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProjectRequest model) {
            super(model);
            id(model.id);
            clientRequestToken(model.clientRequestToken);
            deleteStack(model.deleteStack);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Boolean getDeleteStack() {
            return deleteStack;
        }

        public final void setDeleteStack(Boolean deleteStack) {
            this.deleteStack = deleteStack;
        }

        @Override
        public final Builder deleteStack(Boolean deleteStack) {
            this.deleteStack = deleteStack;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteProjectRequest build() {
            return new DeleteProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
