/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderClient;
import software.amazon.awssdk.services.cognitoidentityprovider.internal.UserAgentUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUsersInGroupResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserType;

public class ListUsersInGroupIterable
implements SdkIterable<ListUsersInGroupResponse> {
    private final CognitoIdentityProviderClient client;
    private final ListUsersInGroupRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUsersInGroupIterable(CognitoIdentityProviderClient client, ListUsersInGroupRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListUsersInGroupResponseFetcher();
    }

    public Iterator<ListUsersInGroupResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UserType> users() {
        Function<ListUsersInGroupResponse, Iterator> getIterator = response -> {
            if (response != null && response.users() != null) {
                return response.users().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUsersInGroupResponseFetcher
    implements SyncPageFetcher<ListUsersInGroupResponse> {
        private ListUsersInGroupResponseFetcher() {
        }

        public boolean hasNextPage(ListUsersInGroupResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUsersInGroupResponse nextPage(ListUsersInGroupResponse previousPage) {
            if (previousPage == null) {
                return ListUsersInGroupIterable.this.client.listUsersInGroup(ListUsersInGroupIterable.this.firstRequest);
            }
            return ListUsersInGroupIterable.this.client.listUsersInGroup((ListUsersInGroupRequest)((Object)ListUsersInGroupIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

