/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.ListOfToxicLabelsCopier;
import software.amazon.awssdk.services.comprehend.model.ToxicLabels;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectToxicContentResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, DetectToxicContentResponse> {
    private static final SdkField<List<ToxicLabels>> RESULT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResultList").getter(DetectToxicContentResponse.getter(DetectToxicContentResponse::resultList)).setter(DetectToxicContentResponse.setter(Builder::resultList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ToxicLabels::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_LIST_FIELD));
    private final List<ToxicLabels> resultList;

    private DetectToxicContentResponse(BuilderImpl builder) {
        super(builder);
        this.resultList = builder.resultList;
    }

    public final boolean hasResultList() {
        return this.resultList != null && !(this.resultList instanceof SdkAutoConstructList);
    }

    public final List<ToxicLabels> resultList() {
        return this.resultList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultList() ? this.resultList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectToxicContentResponse)) {
            return false;
        }
        DetectToxicContentResponse other = (DetectToxicContentResponse)((Object)obj);
        return this.hasResultList() == other.hasResultList() && Objects.equals(this.resultList(), other.resultList());
    }

    public final String toString() {
        return ToString.builder((String)"DetectToxicContentResponse").add("ResultList", this.hasResultList() ? this.resultList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResultList": {
                return Optional.ofNullable(clazz.cast(this.resultList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectToxicContentResponse, T> g) {
        return obj -> g.apply((DetectToxicContentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<ToxicLabels> resultList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectToxicContentResponse model) {
            super(model);
            this.resultList(model.resultList);
        }

        public final List<ToxicLabels.Builder> getResultList() {
            List<ToxicLabels.Builder> result = ListOfToxicLabelsCopier.copyToBuilder(this.resultList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultList(Collection<ToxicLabels.BuilderImpl> resultList) {
            this.resultList = ListOfToxicLabelsCopier.copyFromBuilder(resultList);
        }

        @Override
        public final Builder resultList(Collection<ToxicLabels> resultList) {
            this.resultList = ListOfToxicLabelsCopier.copy(resultList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultList(ToxicLabels ... resultList) {
            this.resultList(Arrays.asList(resultList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultList(Consumer<ToxicLabels.Builder> ... resultList) {
            this.resultList(Stream.of(resultList).map(c -> (ToxicLabels)((ToxicLabels.Builder)ToxicLabels.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DetectToxicContentResponse build() {
            return new DetectToxicContentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetectToxicContentResponse> {
        public Builder resultList(Collection<ToxicLabels> var1);

        public Builder resultList(ToxicLabels ... var1);

        public Builder resultList(Consumer<ToxicLabels.Builder> ... var1);
    }
}

