/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.ComprehendServiceClientConfiguration;
import software.amazon.awssdk.services.comprehend.internal.ComprehendServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.BatchSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest;
import software.amazon.awssdk.services.comprehend.model.ClassifyDocumentResponse;
import software.amazon.awssdk.services.comprehend.model.ComprehendException;
import software.amazon.awssdk.services.comprehend.model.ConcurrentModificationException;
import software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.CreateDatasetRequest;
import software.amazon.awssdk.services.comprehend.model.CreateDatasetResponse;
import software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.CreateEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.CreateEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.CreateFlywheelRequest;
import software.amazon.awssdk.services.comprehend.model.CreateFlywheelResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteFlywheelRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteFlywheelResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeFlywheelIterationResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeFlywheelRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeFlywheelResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeTargetedSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeTargetedSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSyntaxRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSyntaxResponse;
import software.amazon.awssdk.services.comprehend.model.DetectTargetedSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectTargetedSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.DetectToxicContentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectToxicContentResponse;
import software.amazon.awssdk.services.comprehend.model.ImportModelRequest;
import software.amazon.awssdk.services.comprehend.model.ImportModelResponse;
import software.amazon.awssdk.services.comprehend.model.InternalServerException;
import software.amazon.awssdk.services.comprehend.model.InvalidFilterException;
import software.amazon.awssdk.services.comprehend.model.InvalidRequestException;
import software.amazon.awssdk.services.comprehend.model.JobNotFoundException;
import software.amazon.awssdk.services.comprehend.model.KmsKeyValidationException;
import software.amazon.awssdk.services.comprehend.model.ListDatasetsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDatasetsResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEndpointsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEndpointsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryRequest;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelIterationHistoryResponse;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelsRequest;
import software.amazon.awssdk.services.comprehend.model.ListFlywheelsResponse;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.comprehend.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.comprehend.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.comprehend.model.ResourceInUseException;
import software.amazon.awssdk.services.comprehend.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.ResourceNotFoundException;
import software.amazon.awssdk.services.comprehend.model.ResourceUnavailableException;
import software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationRequest;
import software.amazon.awssdk.services.comprehend.model.StartFlywheelIterationResponse;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartTargetedSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartTargetedSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.TagResourceRequest;
import software.amazon.awssdk.services.comprehend.model.TagResourceResponse;
import software.amazon.awssdk.services.comprehend.model.TextSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.TooManyRequestsException;
import software.amazon.awssdk.services.comprehend.model.TooManyTagKeysException;
import software.amazon.awssdk.services.comprehend.model.TooManyTagsException;
import software.amazon.awssdk.services.comprehend.model.UnsupportedLanguageException;
import software.amazon.awssdk.services.comprehend.model.UntagResourceRequest;
import software.amazon.awssdk.services.comprehend.model.UntagResourceResponse;
import software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.UpdateFlywheelRequest;
import software.amazon.awssdk.services.comprehend.model.UpdateFlywheelResponse;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectDominantLanguageRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectKeyPhrasesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectSyntaxRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectTargetedSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ClassifyDocumentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ContainsPiiEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateDatasetRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateEndpointRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateFlywheelRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteFlywheelRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDatasetRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDocumentClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDominantLanguageDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEndpointRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEventsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeFlywheelIterationRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeFlywheelRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeKeyPhrasesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribePiiEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeTargetedSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeTopicsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectDominantLanguageRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectKeyPhrasesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectPiiEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectSyntaxRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectTargetedSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectToxicContentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ImportModelRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDatasetsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDocumentClassificationJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDocumentClassifierSummariesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDocumentClassifiersRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDominantLanguageDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEndpointsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEntitiesDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEntityRecognizerSummariesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEntityRecognizersRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEventsDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListFlywheelIterationHistoryRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListFlywheelsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListKeyPhrasesDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListPiiEntitiesDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListSentimentDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTargetedSentimentDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTopicsDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartDocumentClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartDominantLanguageDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartEventsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartFlywheelIterationRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartKeyPhrasesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartPiiEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartTargetedSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartTopicsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopDominantLanguageDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopEventsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopKeyPhrasesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopPiiEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopTargetedSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopTrainingDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopTrainingEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.UpdateEndpointRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.UpdateFlywheelRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultComprehendClient
implements ComprehendClient {
    private static final Logger log = Logger.loggerFor(DefaultComprehendClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultComprehendClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Comprehend#2.40.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDetectDominantLanguageResponse batchDetectDominantLanguage(BatchDetectDominantLanguageRequest batchDetectDominantLanguageRequest) throws InvalidRequestException, TextSizeLimitExceededException, BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectDominantLanguageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDetectDominantLanguageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, batchDetectDominantLanguageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDetectDominantLanguage");
            BatchDetectDominantLanguageResponse batchDetectDominantLanguageResponse = (BatchDetectDominantLanguageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectDominantLanguage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchDetectDominantLanguageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDetectDominantLanguageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDetectDominantLanguageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$batchDetectDominantLanguage$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDetectEntitiesResponse batchDetectEntities(BatchDetectEntitiesRequest batchDetectEntitiesRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectEntitiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDetectEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, batchDetectEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDetectEntities");
            BatchDetectEntitiesResponse batchDetectEntitiesResponse = (BatchDetectEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectEntities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchDetectEntitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDetectEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDetectEntitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$batchDetectEntities$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDetectKeyPhrasesResponse batchDetectKeyPhrases(BatchDetectKeyPhrasesRequest batchDetectKeyPhrasesRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectKeyPhrasesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDetectKeyPhrasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, batchDetectKeyPhrasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDetectKeyPhrases");
            BatchDetectKeyPhrasesResponse batchDetectKeyPhrasesResponse = (BatchDetectKeyPhrasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectKeyPhrases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchDetectKeyPhrasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDetectKeyPhrasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDetectKeyPhrasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$batchDetectKeyPhrases$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDetectSentimentResponse batchDetectSentiment(BatchDetectSentimentRequest batchDetectSentimentRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectSentimentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDetectSentimentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, batchDetectSentimentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDetectSentiment");
            BatchDetectSentimentResponse batchDetectSentimentResponse = (BatchDetectSentimentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectSentiment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchDetectSentimentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDetectSentimentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDetectSentimentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$batchDetectSentiment$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDetectSyntaxResponse batchDetectSyntax(BatchDetectSyntaxRequest batchDetectSyntaxRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectSyntaxResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDetectSyntaxRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, batchDetectSyntaxRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDetectSyntax");
            BatchDetectSyntaxResponse batchDetectSyntaxResponse = (BatchDetectSyntaxResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectSyntax").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchDetectSyntaxRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDetectSyntaxRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDetectSyntaxResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$batchDetectSyntax$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDetectTargetedSentimentResponse batchDetectTargetedSentiment(BatchDetectTargetedSentimentRequest batchDetectTargetedSentimentRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, BatchSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDetectTargetedSentimentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDetectTargetedSentimentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, batchDetectTargetedSentimentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDetectTargetedSentiment");
            BatchDetectTargetedSentimentResponse batchDetectTargetedSentimentResponse = (BatchDetectTargetedSentimentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDetectTargetedSentiment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchDetectTargetedSentimentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDetectTargetedSentimentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDetectTargetedSentimentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$batchDetectTargetedSentiment$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassifyDocumentResponse classifyDocument(ClassifyDocumentRequest classifyDocumentRequest) throws InvalidRequestException, ResourceUnavailableException, TextSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ClassifyDocumentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)classifyDocumentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, classifyDocumentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ClassifyDocument");
            ClassifyDocumentResponse classifyDocumentResponse = (ClassifyDocumentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ClassifyDocument").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)classifyDocumentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ClassifyDocumentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return classifyDocumentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$classifyDocument$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainsPiiEntitiesResponse containsPiiEntities(ContainsPiiEntitiesRequest containsPiiEntitiesRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ContainsPiiEntitiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)containsPiiEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, containsPiiEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ContainsPiiEntities");
            ContainsPiiEntitiesResponse containsPiiEntitiesResponse = (ContainsPiiEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ContainsPiiEntities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)containsPiiEntitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ContainsPiiEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return containsPiiEntitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$containsPiiEntities$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDatasetResponse createDataset(CreateDatasetRequest createDatasetRequest) throws InvalidRequestException, ResourceInUseException, TooManyTagsException, TooManyRequestsException, ResourceLimitExceededException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatasetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, createDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataset");
            CreateDatasetResponse createDatasetResponse = (CreateDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDatasetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDatasetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$createDataset$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDocumentClassifierResponse createDocumentClassifier(CreateDocumentClassifierRequest createDocumentClassifierRequest) throws InvalidRequestException, ResourceInUseException, TooManyTagsException, TooManyRequestsException, ResourceLimitExceededException, UnsupportedLanguageException, KmsKeyValidationException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDocumentClassifierResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDocumentClassifierRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, createDocumentClassifierRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDocumentClassifier");
            CreateDocumentClassifierResponse createDocumentClassifierResponse = (CreateDocumentClassifierResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDocumentClassifier").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDocumentClassifierRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDocumentClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDocumentClassifierResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$createDocumentClassifier$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEndpointResponse createEndpoint(CreateEndpointRequest createEndpointRequest) throws InvalidRequestException, ResourceInUseException, ResourceLimitExceededException, ResourceNotFoundException, ResourceUnavailableException, TooManyRequestsException, TooManyTagsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, createEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEndpoint");
            CreateEndpointResponse createEndpointResponse = (CreateEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$createEndpoint$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEntityRecognizerResponse createEntityRecognizer(CreateEntityRecognizerRequest createEntityRecognizerRequest) throws InvalidRequestException, ResourceInUseException, TooManyTagsException, TooManyRequestsException, ResourceLimitExceededException, UnsupportedLanguageException, KmsKeyValidationException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEntityRecognizerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEntityRecognizerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, createEntityRecognizerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEntityRecognizer");
            CreateEntityRecognizerResponse createEntityRecognizerResponse = (CreateEntityRecognizerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEntityRecognizer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createEntityRecognizerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEntityRecognizerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEntityRecognizerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$createEntityRecognizer$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFlywheelResponse createFlywheel(CreateFlywheelRequest createFlywheelRequest) throws InvalidRequestException, ResourceInUseException, TooManyTagsException, TooManyRequestsException, ResourceLimitExceededException, UnsupportedLanguageException, KmsKeyValidationException, ResourceNotFoundException, ResourceUnavailableException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFlywheelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFlywheelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, createFlywheelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFlywheel");
            CreateFlywheelResponse createFlywheelResponse = (CreateFlywheelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFlywheel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createFlywheelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFlywheelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFlywheelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$createFlywheel$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDocumentClassifierResponse deleteDocumentClassifier(DeleteDocumentClassifierRequest deleteDocumentClassifierRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDocumentClassifierResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDocumentClassifierRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, deleteDocumentClassifierRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDocumentClassifier");
            DeleteDocumentClassifierResponse deleteDocumentClassifierResponse = (DeleteDocumentClassifierResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDocumentClassifier").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDocumentClassifierRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDocumentClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDocumentClassifierResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$deleteDocumentClassifier$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws InvalidRequestException, ResourceInUseException, ResourceNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, deleteEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEndpoint");
            DeleteEndpointResponse deleteEndpointResponse = (DeleteEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$deleteEndpoint$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEntityRecognizerResponse deleteEntityRecognizer(DeleteEntityRecognizerRequest deleteEntityRecognizerRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEntityRecognizerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEntityRecognizerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, deleteEntityRecognizerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEntityRecognizer");
            DeleteEntityRecognizerResponse deleteEntityRecognizerResponse = (DeleteEntityRecognizerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEntityRecognizer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteEntityRecognizerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEntityRecognizerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEntityRecognizerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$deleteEntityRecognizer$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFlywheelResponse deleteFlywheel(DeleteFlywheelRequest deleteFlywheelRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFlywheelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFlywheelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, deleteFlywheelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFlywheel");
            DeleteFlywheelResponse deleteFlywheelResponse = (DeleteFlywheelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFlywheel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteFlywheelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFlywheelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFlywheelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$deleteFlywheel$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            DeleteResourcePolicyResponse deleteResourcePolicyResponse = (DeleteResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$deleteResourcePolicy$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDatasetResponse describeDataset(DescribeDatasetRequest describeDatasetRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatasetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, describeDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataset");
            DescribeDatasetResponse describeDatasetResponse = (DescribeDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDatasetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDatasetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeDataset$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDocumentClassificationJobResponse describeDocumentClassificationJob(DescribeDocumentClassificationJobRequest describeDocumentClassificationJobRequest) throws InvalidRequestException, TooManyRequestsException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDocumentClassificationJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDocumentClassificationJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, describeDocumentClassificationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDocumentClassificationJob");
            DescribeDocumentClassificationJobResponse describeDocumentClassificationJobResponse = (DescribeDocumentClassificationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDocumentClassificationJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDocumentClassificationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDocumentClassificationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDocumentClassificationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeDocumentClassificationJob$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDocumentClassifierResponse describeDocumentClassifier(DescribeDocumentClassifierRequest describeDocumentClassifierRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDocumentClassifierResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDocumentClassifierRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, describeDocumentClassifierRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDocumentClassifier");
            DescribeDocumentClassifierResponse describeDocumentClassifierResponse = (DescribeDocumentClassifierResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDocumentClassifier").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDocumentClassifierRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDocumentClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDocumentClassifierResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeDocumentClassifier$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDominantLanguageDetectionJobResponse describeDominantLanguageDetectionJob(DescribeDominantLanguageDetectionJobRequest describeDominantLanguageDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDominantLanguageDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDominantLanguageDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, describeDominantLanguageDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDominantLanguageDetectionJob");
            DescribeDominantLanguageDetectionJobResponse describeDominantLanguageDetectionJobResponse = (DescribeDominantLanguageDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDominantLanguageDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDominantLanguageDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDominantLanguageDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDominantLanguageDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeDominantLanguageDetectionJob$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEndpointResponse describeEndpoint(DescribeEndpointRequest describeEndpointRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, describeEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpoint");
            DescribeEndpointResponse describeEndpointResponse = (DescribeEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeEndpoint$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEntitiesDetectionJobResponse describeEntitiesDetectionJob(DescribeEntitiesDetectionJobRequest describeEntitiesDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEntitiesDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEntitiesDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, describeEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEntitiesDetectionJob");
            DescribeEntitiesDetectionJobResponse describeEntitiesDetectionJobResponse = (DescribeEntitiesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEntitiesDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEntitiesDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEntitiesDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeEntitiesDetectionJob$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEntityRecognizerResponse describeEntityRecognizer(DescribeEntityRecognizerRequest describeEntityRecognizerRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEntityRecognizerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEntityRecognizerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, describeEntityRecognizerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEntityRecognizer");
            DescribeEntityRecognizerResponse describeEntityRecognizerResponse = (DescribeEntityRecognizerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEntityRecognizer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEntityRecognizerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEntityRecognizerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEntityRecognizerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeEntityRecognizer$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventsDetectionJobResponse describeEventsDetectionJob(DescribeEventsDetectionJobRequest describeEventsDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEventsDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEventsDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, describeEventsDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventsDetectionJob");
            DescribeEventsDetectionJobResponse describeEventsDetectionJobResponse = (DescribeEventsDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventsDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEventsDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventsDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEventsDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeEventsDetectionJob$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFlywheelResponse describeFlywheel(DescribeFlywheelRequest describeFlywheelRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFlywheelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFlywheelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, describeFlywheelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFlywheel");
            DescribeFlywheelResponse describeFlywheelResponse = (DescribeFlywheelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFlywheel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFlywheelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFlywheelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFlywheelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeFlywheel$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeFlywheelIterationResponse describeFlywheelIteration(DescribeFlywheelIterationRequest describeFlywheelIterationRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFlywheelIterationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFlywheelIterationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, describeFlywheelIterationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFlywheelIteration");
            DescribeFlywheelIterationResponse describeFlywheelIterationResponse = (DescribeFlywheelIterationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFlywheelIteration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeFlywheelIterationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeFlywheelIterationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeFlywheelIterationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeFlywheelIteration$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeKeyPhrasesDetectionJobResponse describeKeyPhrasesDetectionJob(DescribeKeyPhrasesDetectionJobRequest describeKeyPhrasesDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeKeyPhrasesDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeKeyPhrasesDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, describeKeyPhrasesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeKeyPhrasesDetectionJob");
            DescribeKeyPhrasesDetectionJobResponse describeKeyPhrasesDetectionJobResponse = (DescribeKeyPhrasesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeKeyPhrasesDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeKeyPhrasesDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeKeyPhrasesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeKeyPhrasesDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeKeyPhrasesDetectionJob$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePiiEntitiesDetectionJobResponse describePiiEntitiesDetectionJob(DescribePiiEntitiesDetectionJobRequest describePiiEntitiesDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePiiEntitiesDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describePiiEntitiesDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, describePiiEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePiiEntitiesDetectionJob");
            DescribePiiEntitiesDetectionJobResponse describePiiEntitiesDetectionJobResponse = (DescribePiiEntitiesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePiiEntitiesDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describePiiEntitiesDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePiiEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePiiEntitiesDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describePiiEntitiesDetectionJob$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeResourcePolicyResponse describeResourcePolicy(DescribeResourcePolicyRequest describeResourcePolicyRequest) throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, describeResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeResourcePolicy");
            DescribeResourcePolicyResponse describeResourcePolicyResponse = (DescribeResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeResourcePolicy$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSentimentDetectionJobResponse describeSentimentDetectionJob(DescribeSentimentDetectionJobRequest describeSentimentDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSentimentDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSentimentDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, describeSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSentimentDetectionJob");
            DescribeSentimentDetectionJobResponse describeSentimentDetectionJobResponse = (DescribeSentimentDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSentimentDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeSentimentDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSentimentDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSentimentDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeSentimentDetectionJob$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTargetedSentimentDetectionJobResponse describeTargetedSentimentDetectionJob(DescribeTargetedSentimentDetectionJobRequest describeTargetedSentimentDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTargetedSentimentDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTargetedSentimentDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, describeTargetedSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTargetedSentimentDetectionJob");
            DescribeTargetedSentimentDetectionJobResponse describeTargetedSentimentDetectionJobResponse = (DescribeTargetedSentimentDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTargetedSentimentDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTargetedSentimentDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTargetedSentimentDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTargetedSentimentDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeTargetedSentimentDetectionJob$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTopicsDetectionJobResponse describeTopicsDetectionJob(DescribeTopicsDetectionJobRequest describeTopicsDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTopicsDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTopicsDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, describeTopicsDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTopicsDetectionJob");
            DescribeTopicsDetectionJobResponse describeTopicsDetectionJobResponse = (DescribeTopicsDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTopicsDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTopicsDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTopicsDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTopicsDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$describeTopicsDetectionJob$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectDominantLanguageResponse detectDominantLanguage(DetectDominantLanguageRequest detectDominantLanguageRequest) throws InvalidRequestException, TextSizeLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectDominantLanguageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectDominantLanguageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, detectDominantLanguageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectDominantLanguage");
            DetectDominantLanguageResponse detectDominantLanguageResponse = (DetectDominantLanguageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectDominantLanguage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectDominantLanguageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectDominantLanguageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectDominantLanguageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$detectDominantLanguage$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectEntitiesResponse detectEntities(DetectEntitiesRequest detectEntitiesRequest) throws InvalidRequestException, ResourceUnavailableException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectEntitiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, detectEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectEntities");
            DetectEntitiesResponse detectEntitiesResponse = (DetectEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectEntities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectEntitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectEntitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$detectEntities$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectKeyPhrasesResponse detectKeyPhrases(DetectKeyPhrasesRequest detectKeyPhrasesRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectKeyPhrasesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectKeyPhrasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, detectKeyPhrasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectKeyPhrases");
            DetectKeyPhrasesResponse detectKeyPhrasesResponse = (DetectKeyPhrasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectKeyPhrases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectKeyPhrasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectKeyPhrasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectKeyPhrasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$detectKeyPhrases$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectPiiEntitiesResponse detectPiiEntities(DetectPiiEntitiesRequest detectPiiEntitiesRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectPiiEntitiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectPiiEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, detectPiiEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectPiiEntities");
            DetectPiiEntitiesResponse detectPiiEntitiesResponse = (DetectPiiEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectPiiEntities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectPiiEntitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectPiiEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectPiiEntitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$detectPiiEntities$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectSentimentResponse detectSentiment(DetectSentimentRequest detectSentimentRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectSentimentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectSentimentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, detectSentimentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectSentiment");
            DetectSentimentResponse detectSentimentResponse = (DetectSentimentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectSentiment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectSentimentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectSentimentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectSentimentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$detectSentiment$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectSyntaxResponse detectSyntax(DetectSyntaxRequest detectSyntaxRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectSyntaxResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectSyntaxRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, detectSyntaxRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectSyntax");
            DetectSyntaxResponse detectSyntaxResponse = (DetectSyntaxResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectSyntax").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectSyntaxRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectSyntaxRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectSyntaxResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$detectSyntax$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectTargetedSentimentResponse detectTargetedSentiment(DetectTargetedSentimentRequest detectTargetedSentimentRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectTargetedSentimentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectTargetedSentimentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, detectTargetedSentimentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectTargetedSentiment");
            DetectTargetedSentimentResponse detectTargetedSentimentResponse = (DetectTargetedSentimentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectTargetedSentiment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectTargetedSentimentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectTargetedSentimentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectTargetedSentimentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$detectTargetedSentiment$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetectToxicContentResponse detectToxicContent(DetectToxicContentRequest detectToxicContentRequest) throws InvalidRequestException, TextSizeLimitExceededException, UnsupportedLanguageException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetectToxicContentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)detectToxicContentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, detectToxicContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetectToxicContent");
            DetectToxicContentResponse detectToxicContentResponse = (DetectToxicContentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetectToxicContent").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)detectToxicContentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DetectToxicContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return detectToxicContentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$detectToxicContent$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportModelResponse importModel(ImportModelRequest importModelRequest) throws InvalidRequestException, ResourceNotFoundException, ResourceInUseException, ResourceUnavailableException, TooManyTagsException, TooManyRequestsException, ResourceLimitExceededException, KmsKeyValidationException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportModelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, importModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportModel");
            ImportModelResponse importModelResponse = (ImportModelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)importModelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importModelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$importModel$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatasetsResponse listDatasets(ListDatasetsRequest listDatasetsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDatasetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, listDatasetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatasets");
            ListDatasetsResponse listDatasetsResponse = (ListDatasetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDatasetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDatasetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDatasetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listDatasets$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDocumentClassificationJobsResponse listDocumentClassificationJobs(ListDocumentClassificationJobsRequest listDocumentClassificationJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDocumentClassificationJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDocumentClassificationJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, listDocumentClassificationJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDocumentClassificationJobs");
            ListDocumentClassificationJobsResponse listDocumentClassificationJobsResponse = (ListDocumentClassificationJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDocumentClassificationJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDocumentClassificationJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDocumentClassificationJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDocumentClassificationJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listDocumentClassificationJobs$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDocumentClassifierSummariesResponse listDocumentClassifierSummaries(ListDocumentClassifierSummariesRequest listDocumentClassifierSummariesRequest) throws InvalidRequestException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDocumentClassifierSummariesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDocumentClassifierSummariesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, listDocumentClassifierSummariesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDocumentClassifierSummaries");
            ListDocumentClassifierSummariesResponse listDocumentClassifierSummariesResponse = (ListDocumentClassifierSummariesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDocumentClassifierSummaries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDocumentClassifierSummariesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDocumentClassifierSummariesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDocumentClassifierSummariesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listDocumentClassifierSummaries$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDocumentClassifiersResponse listDocumentClassifiers(ListDocumentClassifiersRequest listDocumentClassifiersRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDocumentClassifiersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDocumentClassifiersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, listDocumentClassifiersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDocumentClassifiers");
            ListDocumentClassifiersResponse listDocumentClassifiersResponse = (ListDocumentClassifiersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDocumentClassifiers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDocumentClassifiersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDocumentClassifiersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDocumentClassifiersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listDocumentClassifiers$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDominantLanguageDetectionJobsResponse listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsRequest listDominantLanguageDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDominantLanguageDetectionJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDominantLanguageDetectionJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, listDominantLanguageDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDominantLanguageDetectionJobs");
            ListDominantLanguageDetectionJobsResponse listDominantLanguageDetectionJobsResponse = (ListDominantLanguageDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDominantLanguageDetectionJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDominantLanguageDetectionJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDominantLanguageDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDominantLanguageDetectionJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listDominantLanguageDetectionJobs$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEndpointsResponse listEndpoints(ListEndpointsRequest listEndpointsRequest) throws InvalidRequestException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEndpointsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, listEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEndpoints");
            ListEndpointsResponse listEndpointsResponse = (ListEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listEndpoints$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEntitiesDetectionJobsResponse listEntitiesDetectionJobs(ListEntitiesDetectionJobsRequest listEntitiesDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEntitiesDetectionJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEntitiesDetectionJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, listEntitiesDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEntitiesDetectionJobs");
            ListEntitiesDetectionJobsResponse listEntitiesDetectionJobsResponse = (ListEntitiesDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEntitiesDetectionJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listEntitiesDetectionJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEntitiesDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEntitiesDetectionJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listEntitiesDetectionJobs$99((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEntityRecognizerSummariesResponse listEntityRecognizerSummaries(ListEntityRecognizerSummariesRequest listEntityRecognizerSummariesRequest) throws InvalidRequestException, TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEntityRecognizerSummariesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEntityRecognizerSummariesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, listEntityRecognizerSummariesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEntityRecognizerSummaries");
            ListEntityRecognizerSummariesResponse listEntityRecognizerSummariesResponse = (ListEntityRecognizerSummariesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEntityRecognizerSummaries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listEntityRecognizerSummariesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEntityRecognizerSummariesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEntityRecognizerSummariesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listEntityRecognizerSummaries$101((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEntityRecognizersResponse listEntityRecognizers(ListEntityRecognizersRequest listEntityRecognizersRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEntityRecognizersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEntityRecognizersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, listEntityRecognizersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEntityRecognizers");
            ListEntityRecognizersResponse listEntityRecognizersResponse = (ListEntityRecognizersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEntityRecognizers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listEntityRecognizersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEntityRecognizersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEntityRecognizersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listEntityRecognizers$103((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEventsDetectionJobsResponse listEventsDetectionJobs(ListEventsDetectionJobsRequest listEventsDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventsDetectionJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEventsDetectionJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, listEventsDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEventsDetectionJobs");
            ListEventsDetectionJobsResponse listEventsDetectionJobsResponse = (ListEventsDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventsDetectionJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listEventsDetectionJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEventsDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEventsDetectionJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listEventsDetectionJobs$105((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFlywheelIterationHistoryResponse listFlywheelIterationHistory(ListFlywheelIterationHistoryRequest listFlywheelIterationHistoryRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFlywheelIterationHistoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFlywheelIterationHistoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, listFlywheelIterationHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFlywheelIterationHistory");
            ListFlywheelIterationHistoryResponse listFlywheelIterationHistoryResponse = (ListFlywheelIterationHistoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFlywheelIterationHistory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listFlywheelIterationHistoryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFlywheelIterationHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFlywheelIterationHistoryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listFlywheelIterationHistory$107((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFlywheelsResponse listFlywheels(ListFlywheelsRequest listFlywheelsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFlywheelsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFlywheelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, listFlywheelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFlywheels");
            ListFlywheelsResponse listFlywheelsResponse = (ListFlywheelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFlywheels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listFlywheelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFlywheelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFlywheelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listFlywheels$109((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListKeyPhrasesDetectionJobsResponse listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsRequest listKeyPhrasesDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListKeyPhrasesDetectionJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listKeyPhrasesDetectionJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, listKeyPhrasesDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListKeyPhrasesDetectionJobs");
            ListKeyPhrasesDetectionJobsResponse listKeyPhrasesDetectionJobsResponse = (ListKeyPhrasesDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListKeyPhrasesDetectionJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listKeyPhrasesDetectionJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListKeyPhrasesDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listKeyPhrasesDetectionJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listKeyPhrasesDetectionJobs$111((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPiiEntitiesDetectionJobsResponse listPiiEntitiesDetectionJobs(ListPiiEntitiesDetectionJobsRequest listPiiEntitiesDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPiiEntitiesDetectionJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPiiEntitiesDetectionJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, listPiiEntitiesDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPiiEntitiesDetectionJobs");
            ListPiiEntitiesDetectionJobsResponse listPiiEntitiesDetectionJobsResponse = (ListPiiEntitiesDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPiiEntitiesDetectionJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPiiEntitiesDetectionJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPiiEntitiesDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPiiEntitiesDetectionJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listPiiEntitiesDetectionJobs$113((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSentimentDetectionJobsResponse listSentimentDetectionJobs(ListSentimentDetectionJobsRequest listSentimentDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSentimentDetectionJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSentimentDetectionJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, listSentimentDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSentimentDetectionJobs");
            ListSentimentDetectionJobsResponse listSentimentDetectionJobsResponse = (ListSentimentDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSentimentDetectionJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSentimentDetectionJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSentimentDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSentimentDetectionJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listSentimentDetectionJobs$115((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listTagsForResource$117((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTargetedSentimentDetectionJobsResponse listTargetedSentimentDetectionJobs(ListTargetedSentimentDetectionJobsRequest listTargetedSentimentDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTargetedSentimentDetectionJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTargetedSentimentDetectionJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, listTargetedSentimentDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTargetedSentimentDetectionJobs");
            ListTargetedSentimentDetectionJobsResponse listTargetedSentimentDetectionJobsResponse = (ListTargetedSentimentDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTargetedSentimentDetectionJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTargetedSentimentDetectionJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTargetedSentimentDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTargetedSentimentDetectionJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listTargetedSentimentDetectionJobs$119((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTopicsDetectionJobsResponse listTopicsDetectionJobs(ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest) throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTopicsDetectionJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTopicsDetectionJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, listTopicsDetectionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTopicsDetectionJobs");
            ListTopicsDetectionJobsResponse listTopicsDetectionJobsResponse = (ListTopicsDetectionJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTopicsDetectionJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTopicsDetectionJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTopicsDetectionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTopicsDetectionJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$listTopicsDetectionJobs$121((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) throws InvalidRequestException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            PutResourcePolicyResponse putResourcePolicyResponse = (PutResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$putResourcePolicy$123((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDocumentClassificationJobResponse startDocumentClassificationJob(StartDocumentClassificationJobRequest startDocumentClassificationJobRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, KmsKeyValidationException, TooManyTagsException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDocumentClassificationJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDocumentClassificationJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, startDocumentClassificationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDocumentClassificationJob");
            StartDocumentClassificationJobResponse startDocumentClassificationJobResponse = (StartDocumentClassificationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDocumentClassificationJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startDocumentClassificationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDocumentClassificationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDocumentClassificationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$startDocumentClassificationJob$125((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDominantLanguageDetectionJobResponse startDominantLanguageDetectionJob(StartDominantLanguageDetectionJobRequest startDominantLanguageDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDominantLanguageDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDominantLanguageDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, startDominantLanguageDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDominantLanguageDetectionJob");
            StartDominantLanguageDetectionJobResponse startDominantLanguageDetectionJobResponse = (StartDominantLanguageDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDominantLanguageDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startDominantLanguageDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDominantLanguageDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDominantLanguageDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$startDominantLanguageDetectionJob$127((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartEntitiesDetectionJobResponse startEntitiesDetectionJob(StartEntitiesDetectionJobRequest startEntitiesDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, ResourceUnavailableException, KmsKeyValidationException, TooManyTagsException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartEntitiesDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startEntitiesDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, startEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartEntitiesDetectionJob");
            StartEntitiesDetectionJobResponse startEntitiesDetectionJobResponse = (StartEntitiesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartEntitiesDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startEntitiesDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startEntitiesDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$startEntitiesDetectionJob$129((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartEventsDetectionJobResponse startEventsDetectionJob(StartEventsDetectionJobRequest startEventsDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartEventsDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startEventsDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, startEventsDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartEventsDetectionJob");
            StartEventsDetectionJobResponse startEventsDetectionJobResponse = (StartEventsDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartEventsDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startEventsDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartEventsDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startEventsDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$startEventsDetectionJob$131((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartFlywheelIterationResponse startFlywheelIteration(StartFlywheelIterationRequest startFlywheelIterationRequest) throws InvalidRequestException, TooManyRequestsException, ResourceInUseException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartFlywheelIterationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startFlywheelIterationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, startFlywheelIterationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartFlywheelIteration");
            StartFlywheelIterationResponse startFlywheelIterationResponse = (StartFlywheelIterationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartFlywheelIteration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startFlywheelIterationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartFlywheelIterationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startFlywheelIterationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$startFlywheelIteration$133((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartKeyPhrasesDetectionJobResponse startKeyPhrasesDetectionJob(StartKeyPhrasesDetectionJobRequest startKeyPhrasesDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartKeyPhrasesDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startKeyPhrasesDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, startKeyPhrasesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartKeyPhrasesDetectionJob");
            StartKeyPhrasesDetectionJobResponse startKeyPhrasesDetectionJobResponse = (StartKeyPhrasesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartKeyPhrasesDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startKeyPhrasesDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartKeyPhrasesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startKeyPhrasesDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$startKeyPhrasesDetectionJob$135((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartPiiEntitiesDetectionJobResponse startPiiEntitiesDetectionJob(StartPiiEntitiesDetectionJobRequest startPiiEntitiesDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartPiiEntitiesDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startPiiEntitiesDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, startPiiEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartPiiEntitiesDetectionJob");
            StartPiiEntitiesDetectionJobResponse startPiiEntitiesDetectionJobResponse = (StartPiiEntitiesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartPiiEntitiesDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startPiiEntitiesDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartPiiEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startPiiEntitiesDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$startPiiEntitiesDetectionJob$137((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartSentimentDetectionJobResponse startSentimentDetectionJob(StartSentimentDetectionJobRequest startSentimentDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSentimentDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startSentimentDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, startSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSentimentDetectionJob");
            StartSentimentDetectionJobResponse startSentimentDetectionJobResponse = (StartSentimentDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSentimentDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startSentimentDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartSentimentDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startSentimentDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$startSentimentDetectionJob$139((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartTargetedSentimentDetectionJobResponse startTargetedSentimentDetectionJob(StartTargetedSentimentDetectionJobRequest startTargetedSentimentDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTargetedSentimentDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startTargetedSentimentDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, startTargetedSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTargetedSentimentDetectionJob");
            StartTargetedSentimentDetectionJobResponse startTargetedSentimentDetectionJobResponse = (StartTargetedSentimentDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTargetedSentimentDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startTargetedSentimentDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartTargetedSentimentDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startTargetedSentimentDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$startTargetedSentimentDetectionJob$141((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartTopicsDetectionJobResponse startTopicsDetectionJob(StartTopicsDetectionJobRequest startTopicsDetectionJobRequest) throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, TooManyTagsException, ResourceInUseException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTopicsDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startTopicsDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, startTopicsDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTopicsDetectionJob");
            StartTopicsDetectionJobResponse startTopicsDetectionJobResponse = (StartTopicsDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTopicsDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startTopicsDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartTopicsDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startTopicsDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$startTopicsDetectionJob$143((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopDominantLanguageDetectionJobResponse stopDominantLanguageDetectionJob(StopDominantLanguageDetectionJobRequest stopDominantLanguageDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopDominantLanguageDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopDominantLanguageDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, stopDominantLanguageDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopDominantLanguageDetectionJob");
            StopDominantLanguageDetectionJobResponse stopDominantLanguageDetectionJobResponse = (StopDominantLanguageDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopDominantLanguageDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopDominantLanguageDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopDominantLanguageDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopDominantLanguageDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$stopDominantLanguageDetectionJob$145((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopEntitiesDetectionJobResponse stopEntitiesDetectionJob(StopEntitiesDetectionJobRequest stopEntitiesDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopEntitiesDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopEntitiesDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, stopEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopEntitiesDetectionJob");
            StopEntitiesDetectionJobResponse stopEntitiesDetectionJobResponse = (StopEntitiesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopEntitiesDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopEntitiesDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopEntitiesDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$stopEntitiesDetectionJob$147((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopEventsDetectionJobResponse stopEventsDetectionJob(StopEventsDetectionJobRequest stopEventsDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopEventsDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopEventsDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, stopEventsDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopEventsDetectionJob");
            StopEventsDetectionJobResponse stopEventsDetectionJobResponse = (StopEventsDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopEventsDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopEventsDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopEventsDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopEventsDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$stopEventsDetectionJob$149((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopKeyPhrasesDetectionJobResponse stopKeyPhrasesDetectionJob(StopKeyPhrasesDetectionJobRequest stopKeyPhrasesDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopKeyPhrasesDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopKeyPhrasesDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, stopKeyPhrasesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopKeyPhrasesDetectionJob");
            StopKeyPhrasesDetectionJobResponse stopKeyPhrasesDetectionJobResponse = (StopKeyPhrasesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopKeyPhrasesDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopKeyPhrasesDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopKeyPhrasesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopKeyPhrasesDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$stopKeyPhrasesDetectionJob$151((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopPiiEntitiesDetectionJobResponse stopPiiEntitiesDetectionJob(StopPiiEntitiesDetectionJobRequest stopPiiEntitiesDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopPiiEntitiesDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopPiiEntitiesDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, stopPiiEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopPiiEntitiesDetectionJob");
            StopPiiEntitiesDetectionJobResponse stopPiiEntitiesDetectionJobResponse = (StopPiiEntitiesDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopPiiEntitiesDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopPiiEntitiesDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopPiiEntitiesDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopPiiEntitiesDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$stopPiiEntitiesDetectionJob$153((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopSentimentDetectionJobResponse stopSentimentDetectionJob(StopSentimentDetectionJobRequest stopSentimentDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopSentimentDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopSentimentDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, stopSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopSentimentDetectionJob");
            StopSentimentDetectionJobResponse stopSentimentDetectionJobResponse = (StopSentimentDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopSentimentDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopSentimentDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopSentimentDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopSentimentDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$stopSentimentDetectionJob$155((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopTargetedSentimentDetectionJobResponse stopTargetedSentimentDetectionJob(StopTargetedSentimentDetectionJobRequest stopTargetedSentimentDetectionJobRequest) throws InvalidRequestException, JobNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopTargetedSentimentDetectionJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopTargetedSentimentDetectionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, stopTargetedSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopTargetedSentimentDetectionJob");
            StopTargetedSentimentDetectionJobResponse stopTargetedSentimentDetectionJobResponse = (StopTargetedSentimentDetectionJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopTargetedSentimentDetectionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopTargetedSentimentDetectionJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopTargetedSentimentDetectionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopTargetedSentimentDetectionJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$stopTargetedSentimentDetectionJob$157((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopTrainingDocumentClassifierResponse stopTrainingDocumentClassifier(StopTrainingDocumentClassifierRequest stopTrainingDocumentClassifierRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopTrainingDocumentClassifierResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopTrainingDocumentClassifierRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, stopTrainingDocumentClassifierRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopTrainingDocumentClassifier");
            StopTrainingDocumentClassifierResponse stopTrainingDocumentClassifierResponse = (StopTrainingDocumentClassifierResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopTrainingDocumentClassifier").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopTrainingDocumentClassifierRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopTrainingDocumentClassifierRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopTrainingDocumentClassifierResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$stopTrainingDocumentClassifier$159((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopTrainingEntityRecognizerResponse stopTrainingEntityRecognizer(StopTrainingEntityRecognizerRequest stopTrainingEntityRecognizerRequest) throws InvalidRequestException, TooManyRequestsException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopTrainingEntityRecognizerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopTrainingEntityRecognizerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, stopTrainingEntityRecognizerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopTrainingEntityRecognizer");
            StopTrainingEntityRecognizerResponse stopTrainingEntityRecognizerResponse = (StopTrainingEntityRecognizerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopTrainingEntityRecognizer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopTrainingEntityRecognizerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopTrainingEntityRecognizerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopTrainingEntityRecognizerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$stopTrainingEntityRecognizer$161((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException, ConcurrentModificationException, ResourceNotFoundException, TooManyTagsException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$tagResource$163((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws TooManyTagKeysException, InvalidRequestException, ConcurrentModificationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$untagResource$165((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEndpointResponse updateEndpoint(UpdateEndpointRequest updateEndpointRequest) throws InvalidRequestException, TooManyRequestsException, ResourceInUseException, ResourceLimitExceededException, ResourceNotFoundException, ResourceUnavailableException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, updateEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEndpoint");
            UpdateEndpointResponse updateEndpointResponse = (UpdateEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$updateEndpoint$167((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFlywheelResponse updateFlywheel(UpdateFlywheelRequest updateFlywheelRequest) throws InvalidRequestException, TooManyRequestsException, KmsKeyValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, ComprehendException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFlywheelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "KmsKeyValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyValidationException::builder).build());
                }
                case "InvalidFilterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidFilterException::builder).build());
                }
                case "TooManyTagKeysException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagKeysException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagKeysException::builder).build());
                }
                case "UnsupportedLanguageException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedLanguageException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedLanguageException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ResourceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
                }
                case "ResourceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "BatchSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build());
                }
                case "TextSizeLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "JobNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("JobNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(JobNotFoundException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFlywheelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultComprehendClient.resolveMetricPublishers(clientConfiguration, updateFlywheelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFlywheel");
            UpdateFlywheelResponse updateFlywheelResponse = (UpdateFlywheelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFlywheel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateFlywheelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFlywheelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFlywheelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultComprehendClient.lambda$updateFlywheel$169((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "comprehend";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        ComprehendServiceClientConfigurationBuilder serviceConfigBuilder = new ComprehendServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ComprehendException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final ComprehendServiceClientConfiguration serviceClientConfiguration() {
        return new ComprehendServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateFlywheel$169(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEndpoint$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$165(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopTrainingEntityRecognizer$161(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopTrainingDocumentClassifier$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopTargetedSentimentDetectionJob$157(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopSentimentDetectionJob$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopPiiEntitiesDetectionJob$153(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopKeyPhrasesDetectionJob$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopEventsDetectionJob$149(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopEntitiesDetectionJob$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopDominantLanguageDetectionJob$145(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startTopicsDetectionJob$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startTargetedSentimentDetectionJob$141(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSentimentDetectionJob$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startPiiEntitiesDetectionJob$137(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startKeyPhrasesDetectionJob$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startFlywheelIteration$133(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startEventsDetectionJob$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startEntitiesDetectionJob$129(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDominantLanguageDetectionJob$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDocumentClassificationJob$125(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTopicsDetectionJobs$121(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTargetedSentimentDetectionJobs$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$117(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSentimentDetectionJobs$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPiiEntitiesDetectionJobs$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listKeyPhrasesDetectionJobs$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFlywheels$109(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFlywheelIterationHistory$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEventsDetectionJobs$105(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEntityRecognizers$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEntityRecognizerSummaries$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEntitiesDetectionJobs$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEndpoints$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDominantLanguageDetectionJobs$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDocumentClassifiers$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDocumentClassifierSummaries$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDocumentClassificationJobs$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatasets$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importModel$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectToxicContent$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectTargetedSentiment$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectSyntax$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectSentiment$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectPiiEntities$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectKeyPhrases$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectEntities$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detectDominantLanguage$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTopicsDetectionJob$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTargetedSentimentDetectionJob$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSentimentDetectionJob$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeResourcePolicy$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePiiEntitiesDetectionJob$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeKeyPhrasesDetectionJob$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFlywheelIteration$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFlywheel$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEventsDetectionJob$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEntityRecognizer$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEntitiesDetectionJob$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpoint$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDominantLanguageDetectionJob$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDocumentClassifier$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDocumentClassificationJob$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataset$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFlywheel$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEntityRecognizer$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEndpoint$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDocumentClassifier$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFlywheel$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEntityRecognizer$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEndpoint$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDocumentClassifier$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataset$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$containsPiiEntities$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$classifyDocument$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDetectTargetedSentiment$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDetectSyntax$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDetectSentiment$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDetectKeyPhrases$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDetectEntities$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDetectDominantLanguage$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

