/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DocumentReadMode {
    SERVICE_DEFAULT("SERVICE_DEFAULT"),
    FORCE_DOCUMENT_READ_ACTION("FORCE_DOCUMENT_READ_ACTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DocumentReadMode> VALUE_MAP;
    private final String value;

    private DocumentReadMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentReadMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentReadMode> knownValues() {
        EnumSet<DocumentReadMode> knownValues = EnumSet.allOf(DocumentReadMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DocumentReadMode.class, DocumentReadMode::toString);
    }
}

