/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.FlywheelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlywheelFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlywheelFilter> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(FlywheelFilter.getter(FlywheelFilter::statusAsString)).setter(FlywheelFilter.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimeAfter").getter(FlywheelFilter.getter(FlywheelFilter::creationTimeAfter)).setter(FlywheelFilter.setter(Builder::creationTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimeBefore").getter(FlywheelFilter.getter(FlywheelFilter::creationTimeBefore)).setter(FlywheelFilter.setter(Builder::creationTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, CREATION_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlywheelFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Instant creationTimeAfter;
    private final Instant creationTimeBefore;

    private FlywheelFilter(BuilderImpl builder) {
        this.status = builder.status;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
    }

    public final FlywheelStatus status() {
        return FlywheelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTimeAfter() {
        return this.creationTimeAfter;
    }

    public final Instant creationTimeBefore() {
        return this.creationTimeBefore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeBefore());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlywheelFilter)) {
            return false;
        }
        FlywheelFilter other = (FlywheelFilter)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTimeAfter(), other.creationTimeAfter()) && Objects.equals(this.creationTimeBefore(), other.creationTimeBefore());
    }

    public final String toString() {
        return ToString.builder((String)"FlywheelFilter").add("Status", (Object)this.statusAsString()).add("CreationTimeAfter", (Object)this.creationTimeAfter()).add("CreationTimeBefore", (Object)this.creationTimeBefore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.creationTimeAfter()));
            }
            case "CreationTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.creationTimeBefore()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("CreationTimeAfter", CREATION_TIME_AFTER_FIELD);
        map.put("CreationTimeBefore", CREATION_TIME_BEFORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlywheelFilter, T> g) {
        return obj -> g.apply((FlywheelFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Instant creationTimeAfter;
        private Instant creationTimeBefore;

        private BuilderImpl() {
        }

        private BuilderImpl(FlywheelFilter model) {
            this.status(model.status);
            this.creationTimeAfter(model.creationTimeAfter);
            this.creationTimeBefore(model.creationTimeBefore);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FlywheelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return this.creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return this.creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public FlywheelFilter build() {
            return new FlywheelFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlywheelFilter> {
        public Builder status(String var1);

        public Builder status(FlywheelStatus var1);

        public Builder creationTimeAfter(Instant var1);

        public Builder creationTimeBefore(Instant var1);
    }
}

