/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.SentimentScore;
import software.amazon.awssdk.services.comprehend.model.SentimentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MentionSentiment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MentionSentiment> {
    private static final SdkField<String> SENTIMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sentiment").getter(MentionSentiment.getter(MentionSentiment::sentimentAsString)).setter(MentionSentiment.setter(Builder::sentiment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sentiment").build()}).build();
    private static final SdkField<SentimentScore> SENTIMENT_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SentimentScore").getter(MentionSentiment.getter(MentionSentiment::sentimentScore)).setter(MentionSentiment.setter(Builder::sentimentScore)).constructor(SentimentScore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentimentScore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENTIMENT_FIELD, SENTIMENT_SCORE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MentionSentiment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sentiment;
    private final SentimentScore sentimentScore;

    private MentionSentiment(BuilderImpl builder) {
        this.sentiment = builder.sentiment;
        this.sentimentScore = builder.sentimentScore;
    }

    public final SentimentType sentiment() {
        return SentimentType.fromValue(this.sentiment);
    }

    public final String sentimentAsString() {
        return this.sentiment;
    }

    public final SentimentScore sentimentScore() {
        return this.sentimentScore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentScore());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MentionSentiment)) {
            return false;
        }
        MentionSentiment other = (MentionSentiment)obj;
        return Objects.equals(this.sentimentAsString(), other.sentimentAsString()) && Objects.equals(this.sentimentScore(), other.sentimentScore());
    }

    public final String toString() {
        return ToString.builder((String)"MentionSentiment").add("Sentiment", (Object)this.sentimentAsString()).add("SentimentScore", (Object)this.sentimentScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sentiment": {
                return Optional.ofNullable(clazz.cast(this.sentimentAsString()));
            }
            case "SentimentScore": {
                return Optional.ofNullable(clazz.cast(this.sentimentScore()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Sentiment", SENTIMENT_FIELD);
        map.put("SentimentScore", SENTIMENT_SCORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MentionSentiment, T> g) {
        return obj -> g.apply((MentionSentiment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sentiment;
        private SentimentScore sentimentScore;

        private BuilderImpl() {
        }

        private BuilderImpl(MentionSentiment model) {
            this.sentiment(model.sentiment);
            this.sentimentScore(model.sentimentScore);
        }

        public final String getSentiment() {
            return this.sentiment;
        }

        public final void setSentiment(String sentiment) {
            this.sentiment = sentiment;
        }

        @Override
        public final Builder sentiment(String sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        @Override
        public final Builder sentiment(SentimentType sentiment) {
            this.sentiment(sentiment == null ? null : sentiment.toString());
            return this;
        }

        public final SentimentScore.Builder getSentimentScore() {
            return this.sentimentScore != null ? this.sentimentScore.toBuilder() : null;
        }

        public final void setSentimentScore(SentimentScore.BuilderImpl sentimentScore) {
            this.sentimentScore = sentimentScore != null ? sentimentScore.build() : null;
        }

        @Override
        public final Builder sentimentScore(SentimentScore sentimentScore) {
            this.sentimentScore = sentimentScore;
            return this;
        }

        public MentionSentiment build() {
            return new MentionSentiment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MentionSentiment> {
        public Builder sentiment(String var1);

        public Builder sentiment(SentimentType var1);

        public Builder sentimentScore(SentimentScore var1);

        default public Builder sentimentScore(Consumer<SentimentScore.Builder> sentimentScore) {
            return this.sentimentScore((SentimentScore)((SentimentScore.Builder)SentimentScore.builder().applyMutation(sentimentScore)).build());
        }
    }
}

