/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MaximumExecutionFrequency {
    ONE_HOUR("One_Hour"),
    THREE_HOURS("Three_Hours"),
    SIX_HOURS("Six_Hours"),
    TWELVE_HOURS("Twelve_Hours"),
    TWENTY_FOUR_HOURS("TwentyFour_Hours"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MaximumExecutionFrequency> VALUE_MAP;
    private final String value;

    private MaximumExecutionFrequency(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MaximumExecutionFrequency fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MaximumExecutionFrequency> knownValues() {
        EnumSet<MaximumExecutionFrequency> knownValues = EnumSet.allOf(MaximumExecutionFrequency.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MaximumExecutionFrequency.class, MaximumExecutionFrequency::toString);
    }
}

