/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.ConfigServiceClientConfiguration;
import software.amazon.awssdk.services.config.internal.ConfigServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.config.model.AssociateResourceTypesRequest;
import software.amazon.awssdk.services.config.model.AssociateResourceTypesResponse;
import software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigResponse;
import software.amazon.awssdk.services.config.model.ConfigException;
import software.amazon.awssdk.services.config.model.ConflictException;
import software.amazon.awssdk.services.config.model.ConformancePackTemplateValidationException;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.DeleteConformancePackRequest;
import software.amazon.awssdk.services.config.model.DeleteConformancePackResponse;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsRequest;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsResponse;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConformancePackRequest;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConformancePackResponse;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestRequest;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestResponse;
import software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationRequest;
import software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationResponse;
import software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.DeleteResourceConfigRequest;
import software.amazon.awssdk.services.config.model.DeleteResourceConfigResponse;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.DeleteServiceLinkedConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.DeleteServiceLinkedConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.DeleteStoredQueryRequest;
import software.amazon.awssdk.services.config.model.DeleteStoredQueryResponse;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse;
import software.amazon.awssdk.services.config.model.DisassociateResourceTypesRequest;
import software.amazon.awssdk.services.config.model.DisassociateResourceTypesResponse;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.GetAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeResponse;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetCustomRulePolicyRequest;
import software.amazon.awssdk.services.config.model.GetCustomRulePolicyResponse;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationCustomRulePolicyRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationCustomRulePolicyResponse;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse;
import software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryRequest;
import software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryResponse;
import software.amazon.awssdk.services.config.model.GetStoredQueryRequest;
import software.amazon.awssdk.services.config.model.GetStoredQueryResponse;
import software.amazon.awssdk.services.config.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.config.model.InsufficientDeliveryPolicyException;
import software.amazon.awssdk.services.config.model.InsufficientPermissionsException;
import software.amazon.awssdk.services.config.model.InvalidConfigurationRecorderNameException;
import software.amazon.awssdk.services.config.model.InvalidDeliveryChannelNameException;
import software.amazon.awssdk.services.config.model.InvalidExpressionException;
import software.amazon.awssdk.services.config.model.InvalidLimitException;
import software.amazon.awssdk.services.config.model.InvalidNextTokenException;
import software.amazon.awssdk.services.config.model.InvalidParameterValueException;
import software.amazon.awssdk.services.config.model.InvalidRecordingGroupException;
import software.amazon.awssdk.services.config.model.InvalidResultTokenException;
import software.amazon.awssdk.services.config.model.InvalidRoleException;
import software.amazon.awssdk.services.config.model.InvalidS3KeyPrefixException;
import software.amazon.awssdk.services.config.model.InvalidS3KmsKeyArnException;
import software.amazon.awssdk.services.config.model.InvalidSnsTopicArnException;
import software.amazon.awssdk.services.config.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.config.model.LastDeliveryChannelDeleteFailedException;
import software.amazon.awssdk.services.config.model.LimitExceededException;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ListConfigurationRecordersRequest;
import software.amazon.awssdk.services.config.model.ListConfigurationRecordersResponse;
import software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest;
import software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresResponse;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest;
import software.amazon.awssdk.services.config.model.ListResourceEvaluationsResponse;
import software.amazon.awssdk.services.config.model.ListStoredQueriesRequest;
import software.amazon.awssdk.services.config.model.ListStoredQueriesResponse;
import software.amazon.awssdk.services.config.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.config.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.config.model.MaxActiveResourcesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConfigRulesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConfigurationRecordersExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConformancePacksExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfDeliveryChannelsExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfOrganizationConfigRulesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfOrganizationConformancePacksExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfRetentionConfigurationsExceededException;
import software.amazon.awssdk.services.config.model.NoAvailableConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoAvailableDeliveryChannelException;
import software.amazon.awssdk.services.config.model.NoAvailableOrganizationException;
import software.amazon.awssdk.services.config.model.NoRunningConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoSuchBucketException;
import software.amazon.awssdk.services.config.model.NoSuchConfigRuleException;
import software.amazon.awssdk.services.config.model.NoSuchConfigRuleInConformancePackException;
import software.amazon.awssdk.services.config.model.NoSuchConfigurationAggregatorException;
import software.amazon.awssdk.services.config.model.NoSuchConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoSuchConformancePackException;
import software.amazon.awssdk.services.config.model.NoSuchDeliveryChannelException;
import software.amazon.awssdk.services.config.model.NoSuchOrganizationConfigRuleException;
import software.amazon.awssdk.services.config.model.NoSuchOrganizationConformancePackException;
import software.amazon.awssdk.services.config.model.NoSuchRemediationConfigurationException;
import software.amazon.awssdk.services.config.model.NoSuchRemediationExceptionException;
import software.amazon.awssdk.services.config.model.NoSuchRetentionConfigurationException;
import software.amazon.awssdk.services.config.model.OrganizationAccessDeniedException;
import software.amazon.awssdk.services.config.model.OrganizationAllFeaturesNotEnabledException;
import software.amazon.awssdk.services.config.model.OrganizationConformancePackTemplateValidationException;
import software.amazon.awssdk.services.config.model.OversizedConfigurationItemException;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.PutConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.PutConformancePackRequest;
import software.amazon.awssdk.services.config.model.PutConformancePackResponse;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.PutEvaluationsRequest;
import software.amazon.awssdk.services.config.model.PutEvaluationsResponse;
import software.amazon.awssdk.services.config.model.PutExternalEvaluationRequest;
import software.amazon.awssdk.services.config.model.PutExternalEvaluationResponse;
import software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutOrganizationConformancePackRequest;
import software.amazon.awssdk.services.config.model.PutOrganizationConformancePackResponse;
import software.amazon.awssdk.services.config.model.PutRemediationConfigurationsRequest;
import software.amazon.awssdk.services.config.model.PutRemediationConfigurationsResponse;
import software.amazon.awssdk.services.config.model.PutRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.PutRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.PutResourceConfigRequest;
import software.amazon.awssdk.services.config.model.PutResourceConfigResponse;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.PutServiceLinkedConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.PutServiceLinkedConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.PutStoredQueryRequest;
import software.amazon.awssdk.services.config.model.PutStoredQueryResponse;
import software.amazon.awssdk.services.config.model.RemediationInProgressException;
import software.amazon.awssdk.services.config.model.ResourceConcurrentModificationException;
import software.amazon.awssdk.services.config.model.ResourceInUseException;
import software.amazon.awssdk.services.config.model.ResourceNotDiscoveredException;
import software.amazon.awssdk.services.config.model.ResourceNotFoundException;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.SelectResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectResourceConfigResponse;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationRequest;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationResponse;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.StartRemediationExecutionRequest;
import software.amazon.awssdk.services.config.model.StartRemediationExecutionResponse;
import software.amazon.awssdk.services.config.model.StartResourceEvaluationRequest;
import software.amazon.awssdk.services.config.model.StartResourceEvaluationResponse;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.TagResourceRequest;
import software.amazon.awssdk.services.config.model.TagResourceResponse;
import software.amazon.awssdk.services.config.model.TooManyTagsException;
import software.amazon.awssdk.services.config.model.UnmodifiableEntityException;
import software.amazon.awssdk.services.config.model.UntagResourceRequest;
import software.amazon.awssdk.services.config.model.UntagResourceResponse;
import software.amazon.awssdk.services.config.model.ValidationException;
import software.amazon.awssdk.services.config.transform.AssociateResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.BatchGetAggregateResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.BatchGetResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteAggregationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigurationAggregatorRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteDeliveryChannelRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteEvaluationResultsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteOrganizationConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteOrganizationConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeletePendingAggregationRequestRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteRemediationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteRemediationExceptionsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteRetentionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteServiceLinkedConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteStoredQueryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeliverConfigSnapshotRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregateComplianceByConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregateComplianceByConformancePacksRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregationAuthorizationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRuleEvaluationStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationAggregatorSourcesStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationAggregatorsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecorderStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecordersRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConformancePackComplianceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConformancePackStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConformancePacksRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConfigRuleStatusesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConformancePackStatusesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConformancePacksRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribePendingAggregationRequestsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRemediationConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRemediationExceptionsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRemediationExecutionStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRetentionConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DisassociateResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateComplianceDetailsByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateConfigRuleComplianceSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateConformancePackComplianceSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateDiscoveredResourceCountsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByResourceTypeRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetConformancePackComplianceDetailsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetConformancePackComplianceSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetCustomRulePolicyRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetDiscoveredResourceCountsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetOrganizationConfigRuleDetailedStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetOrganizationConformancePackDetailedStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetOrganizationCustomRulePolicyRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetResourceConfigHistoryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetResourceEvaluationSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetStoredQueryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListAggregateDiscoveredResourcesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListConfigurationRecordersRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListConformancePackComplianceScoresRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListDiscoveredResourcesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListResourceEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListStoredQueriesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutAggregationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigurationAggregatorRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutDeliveryChannelRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutExternalEvaluationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutOrganizationConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutOrganizationConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutRemediationConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutRemediationExceptionsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutRetentionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutServiceLinkedConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutStoredQueryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.SelectAggregateResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.SelectResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigRulesEvaluationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartRemediationExecutionRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartResourceEvaluationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StopConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultConfigClient
implements ConfigClient {
    private static final Logger log = Logger.loggerFor(DefaultConfigClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultConfigClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Config_Service#2.40.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateResourceTypesResponse associateResourceTypes(AssociateResourceTypesRequest associateResourceTypesRequest) throws ValidationException, ConflictException, NoSuchConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateResourceTypesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateResourceTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, associateResourceTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateResourceTypes");
            AssociateResourceTypesResponse associateResourceTypesResponse = (AssociateResourceTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateResourceTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateResourceTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateResourceTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateResourceTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$associateResourceTypes$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetAggregateResourceConfigResponse batchGetAggregateResourceConfig(BatchGetAggregateResourceConfigRequest batchGetAggregateResourceConfigRequest) throws ValidationException, NoSuchConfigurationAggregatorException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetAggregateResourceConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetAggregateResourceConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, batchGetAggregateResourceConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetAggregateResourceConfig");
            BatchGetAggregateResourceConfigResponse batchGetAggregateResourceConfigResponse = (BatchGetAggregateResourceConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetAggregateResourceConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchGetAggregateResourceConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetAggregateResourceConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetAggregateResourceConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$batchGetAggregateResourceConfig$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetResourceConfigResponse batchGetResourceConfig(BatchGetResourceConfigRequest batchGetResourceConfigRequest) throws ValidationException, NoAvailableConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetResourceConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetResourceConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, batchGetResourceConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetResourceConfig");
            BatchGetResourceConfigResponse batchGetResourceConfigResponse = (BatchGetResourceConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetResourceConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchGetResourceConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchGetResourceConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchGetResourceConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$batchGetResourceConfig$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAggregationAuthorizationResponse deleteAggregationAuthorization(DeleteAggregationAuthorizationRequest deleteAggregationAuthorizationRequest) throws InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAggregationAuthorizationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAggregationAuthorizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, deleteAggregationAuthorizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAggregationAuthorization");
            DeleteAggregationAuthorizationResponse deleteAggregationAuthorizationResponse = (DeleteAggregationAuthorizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAggregationAuthorization").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAggregationAuthorizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAggregationAuthorizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAggregationAuthorizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$deleteAggregationAuthorization$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConfigRuleResponse deleteConfigRule(DeleteConfigRuleRequest deleteConfigRuleRequest) throws NoSuchConfigRuleException, ResourceInUseException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConfigRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, deleteConfigRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConfigRule");
            DeleteConfigRuleResponse deleteConfigRuleResponse = (DeleteConfigRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteConfigRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConfigRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConfigRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$deleteConfigRule$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConfigurationAggregatorResponse deleteConfigurationAggregator(DeleteConfigurationAggregatorRequest deleteConfigurationAggregatorRequest) throws NoSuchConfigurationAggregatorException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigurationAggregatorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConfigurationAggregatorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, deleteConfigurationAggregatorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConfigurationAggregator");
            DeleteConfigurationAggregatorResponse deleteConfigurationAggregatorResponse = (DeleteConfigurationAggregatorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationAggregator").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteConfigurationAggregatorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConfigurationAggregatorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConfigurationAggregatorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$deleteConfigurationAggregator$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConfigurationRecorderResponse deleteConfigurationRecorder(DeleteConfigurationRecorderRequest deleteConfigurationRecorderRequest) throws NoSuchConfigurationRecorderException, UnmodifiableEntityException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfigurationRecorderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConfigurationRecorderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, deleteConfigurationRecorderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConfigurationRecorder");
            DeleteConfigurationRecorderResponse deleteConfigurationRecorderResponse = (DeleteConfigurationRecorderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfigurationRecorder").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteConfigurationRecorderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConfigurationRecorderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConfigurationRecorderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$deleteConfigurationRecorder$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConformancePackResponse deleteConformancePack(DeleteConformancePackRequest deleteConformancePackRequest) throws NoSuchConformancePackException, ResourceInUseException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConformancePackResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConformancePackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, deleteConformancePackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConformancePack");
            DeleteConformancePackResponse deleteConformancePackResponse = (DeleteConformancePackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConformancePack").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteConformancePackRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConformancePackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConformancePackResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$deleteConformancePack$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDeliveryChannelResponse deleteDeliveryChannel(DeleteDeliveryChannelRequest deleteDeliveryChannelRequest) throws NoSuchDeliveryChannelException, LastDeliveryChannelDeleteFailedException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDeliveryChannelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDeliveryChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, deleteDeliveryChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDeliveryChannel");
            DeleteDeliveryChannelResponse deleteDeliveryChannelResponse = (DeleteDeliveryChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDeliveryChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDeliveryChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDeliveryChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDeliveryChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$deleteDeliveryChannel$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEvaluationResultsResponse deleteEvaluationResults(DeleteEvaluationResultsRequest deleteEvaluationResultsRequest) throws NoSuchConfigRuleException, ResourceInUseException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEvaluationResultsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEvaluationResultsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, deleteEvaluationResultsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEvaluationResults");
            DeleteEvaluationResultsResponse deleteEvaluationResultsResponse = (DeleteEvaluationResultsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEvaluationResults").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteEvaluationResultsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEvaluationResultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEvaluationResultsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$deleteEvaluationResults$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteOrganizationConfigRuleResponse deleteOrganizationConfigRule(DeleteOrganizationConfigRuleRequest deleteOrganizationConfigRuleRequest) throws NoSuchOrganizationConfigRuleException, ResourceInUseException, OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteOrganizationConfigRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteOrganizationConfigRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, deleteOrganizationConfigRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteOrganizationConfigRule");
            DeleteOrganizationConfigRuleResponse deleteOrganizationConfigRuleResponse = (DeleteOrganizationConfigRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteOrganizationConfigRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteOrganizationConfigRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteOrganizationConfigRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteOrganizationConfigRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$deleteOrganizationConfigRule$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteOrganizationConformancePackResponse deleteOrganizationConformancePack(DeleteOrganizationConformancePackRequest deleteOrganizationConformancePackRequest) throws NoSuchOrganizationConformancePackException, ResourceInUseException, OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteOrganizationConformancePackResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteOrganizationConformancePackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, deleteOrganizationConformancePackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteOrganizationConformancePack");
            DeleteOrganizationConformancePackResponse deleteOrganizationConformancePackResponse = (DeleteOrganizationConformancePackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteOrganizationConformancePack").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteOrganizationConformancePackRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteOrganizationConformancePackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteOrganizationConformancePackResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$deleteOrganizationConformancePack$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePendingAggregationRequestResponse deletePendingAggregationRequest(DeletePendingAggregationRequestRequest deletePendingAggregationRequestRequest) throws InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePendingAggregationRequestResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePendingAggregationRequestRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, deletePendingAggregationRequestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePendingAggregationRequest");
            DeletePendingAggregationRequestResponse deletePendingAggregationRequestResponse = (DeletePendingAggregationRequestResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePendingAggregationRequest").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deletePendingAggregationRequestRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePendingAggregationRequestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePendingAggregationRequestResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$deletePendingAggregationRequest$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRemediationConfigurationResponse deleteRemediationConfiguration(DeleteRemediationConfigurationRequest deleteRemediationConfigurationRequest) throws NoSuchRemediationConfigurationException, RemediationInProgressException, InsufficientPermissionsException, InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRemediationConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRemediationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, deleteRemediationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRemediationConfiguration");
            DeleteRemediationConfigurationResponse deleteRemediationConfigurationResponse = (DeleteRemediationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRemediationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteRemediationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRemediationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRemediationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$deleteRemediationConfiguration$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRemediationExceptionsResponse deleteRemediationExceptions(DeleteRemediationExceptionsRequest deleteRemediationExceptionsRequest) throws NoSuchRemediationExceptionException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRemediationExceptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRemediationExceptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, deleteRemediationExceptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRemediationExceptions");
            DeleteRemediationExceptionsResponse deleteRemediationExceptionsResponse = (DeleteRemediationExceptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRemediationExceptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteRemediationExceptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRemediationExceptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRemediationExceptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$deleteRemediationExceptions$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourceConfigResponse deleteResourceConfig(DeleteResourceConfigRequest deleteResourceConfigRequest) throws ValidationException, NoRunningConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourceConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourceConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, deleteResourceConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourceConfig");
            DeleteResourceConfigResponse deleteResourceConfigResponse = (DeleteResourceConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourceConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteResourceConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourceConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourceConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$deleteResourceConfig$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRetentionConfigurationResponse deleteRetentionConfiguration(DeleteRetentionConfigurationRequest deleteRetentionConfigurationRequest) throws InvalidParameterValueException, NoSuchRetentionConfigurationException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRetentionConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRetentionConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, deleteRetentionConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRetentionConfiguration");
            DeleteRetentionConfigurationResponse deleteRetentionConfigurationResponse = (DeleteRetentionConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRetentionConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteRetentionConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRetentionConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRetentionConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$deleteRetentionConfiguration$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteServiceLinkedConfigurationRecorderResponse deleteServiceLinkedConfigurationRecorder(DeleteServiceLinkedConfigurationRecorderRequest deleteServiceLinkedConfigurationRecorderRequest) throws NoSuchConfigurationRecorderException, ValidationException, ConflictException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteServiceLinkedConfigurationRecorderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteServiceLinkedConfigurationRecorderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, deleteServiceLinkedConfigurationRecorderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteServiceLinkedConfigurationRecorder");
            DeleteServiceLinkedConfigurationRecorderResponse deleteServiceLinkedConfigurationRecorderResponse = (DeleteServiceLinkedConfigurationRecorderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteServiceLinkedConfigurationRecorder").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteServiceLinkedConfigurationRecorderRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteServiceLinkedConfigurationRecorderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteServiceLinkedConfigurationRecorderResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$deleteServiceLinkedConfigurationRecorder$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStoredQueryResponse deleteStoredQuery(DeleteStoredQueryRequest deleteStoredQueryRequest) throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStoredQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteStoredQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, deleteStoredQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStoredQuery");
            DeleteStoredQueryResponse deleteStoredQueryResponse = (DeleteStoredQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStoredQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteStoredQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteStoredQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteStoredQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$deleteStoredQuery$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeliverConfigSnapshotResponse deliverConfigSnapshot(DeliverConfigSnapshotRequest deliverConfigSnapshotRequest) throws NoSuchDeliveryChannelException, NoAvailableConfigurationRecorderException, NoRunningConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeliverConfigSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deliverConfigSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, deliverConfigSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeliverConfigSnapshot");
            DeliverConfigSnapshotResponse deliverConfigSnapshotResponse = (DeliverConfigSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeliverConfigSnapshot").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deliverConfigSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeliverConfigSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deliverConfigSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$deliverConfigSnapshot$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAggregateComplianceByConfigRulesResponse describeAggregateComplianceByConfigRules(DescribeAggregateComplianceByConfigRulesRequest describeAggregateComplianceByConfigRulesRequest) throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAggregateComplianceByConfigRulesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAggregateComplianceByConfigRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeAggregateComplianceByConfigRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAggregateComplianceByConfigRules");
            DescribeAggregateComplianceByConfigRulesResponse describeAggregateComplianceByConfigRulesResponse = (DescribeAggregateComplianceByConfigRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAggregateComplianceByConfigRules").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAggregateComplianceByConfigRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAggregateComplianceByConfigRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAggregateComplianceByConfigRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeAggregateComplianceByConfigRules$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAggregateComplianceByConformancePacksResponse describeAggregateComplianceByConformancePacks(DescribeAggregateComplianceByConformancePacksRequest describeAggregateComplianceByConformancePacksRequest) throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAggregateComplianceByConformancePacksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAggregateComplianceByConformancePacksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeAggregateComplianceByConformancePacksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAggregateComplianceByConformancePacks");
            DescribeAggregateComplianceByConformancePacksResponse describeAggregateComplianceByConformancePacksResponse = (DescribeAggregateComplianceByConformancePacksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAggregateComplianceByConformancePacks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAggregateComplianceByConformancePacksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAggregateComplianceByConformancePacksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAggregateComplianceByConformancePacksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeAggregateComplianceByConformancePacks$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAggregationAuthorizationsResponse describeAggregationAuthorizations(DescribeAggregationAuthorizationsRequest describeAggregationAuthorizationsRequest) throws InvalidParameterValueException, InvalidNextTokenException, InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAggregationAuthorizationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAggregationAuthorizationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeAggregationAuthorizationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAggregationAuthorizations");
            DescribeAggregationAuthorizationsResponse describeAggregationAuthorizationsResponse = (DescribeAggregationAuthorizationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAggregationAuthorizations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAggregationAuthorizationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAggregationAuthorizationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAggregationAuthorizationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeAggregationAuthorizations$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeComplianceByConfigRuleResponse describeComplianceByConfigRule(DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) throws InvalidParameterValueException, NoSuchConfigRuleException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeComplianceByConfigRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeComplianceByConfigRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeComplianceByConfigRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeComplianceByConfigRule");
            DescribeComplianceByConfigRuleResponse describeComplianceByConfigRuleResponse = (DescribeComplianceByConfigRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeComplianceByConfigRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeComplianceByConfigRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeComplianceByConfigRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeComplianceByConfigRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeComplianceByConfigRule$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeComplianceByResourceResponse describeComplianceByResource(DescribeComplianceByResourceRequest describeComplianceByResourceRequest) throws InvalidParameterValueException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeComplianceByResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeComplianceByResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeComplianceByResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeComplianceByResource");
            DescribeComplianceByResourceResponse describeComplianceByResourceResponse = (DescribeComplianceByResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeComplianceByResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeComplianceByResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeComplianceByResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeComplianceByResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeComplianceByResource$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigRuleEvaluationStatusResponse describeConfigRuleEvaluationStatus(DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest) throws NoSuchConfigRuleException, InvalidParameterValueException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigRuleEvaluationStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConfigRuleEvaluationStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeConfigRuleEvaluationStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConfigRuleEvaluationStatus");
            DescribeConfigRuleEvaluationStatusResponse describeConfigRuleEvaluationStatusResponse = (DescribeConfigRuleEvaluationStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigRuleEvaluationStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConfigRuleEvaluationStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConfigRuleEvaluationStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConfigRuleEvaluationStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeConfigRuleEvaluationStatus$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigRulesResponse describeConfigRules(DescribeConfigRulesRequest describeConfigRulesRequest) throws NoSuchConfigRuleException, InvalidNextTokenException, InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigRulesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConfigRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeConfigRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConfigRules");
            DescribeConfigRulesResponse describeConfigRulesResponse = (DescribeConfigRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigRules").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConfigRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConfigRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConfigRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeConfigRules$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigurationAggregatorSourcesStatusResponse describeConfigurationAggregatorSourcesStatus(DescribeConfigurationAggregatorSourcesStatusRequest describeConfigurationAggregatorSourcesStatusRequest) throws InvalidParameterValueException, NoSuchConfigurationAggregatorException, InvalidNextTokenException, InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigurationAggregatorSourcesStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConfigurationAggregatorSourcesStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeConfigurationAggregatorSourcesStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConfigurationAggregatorSourcesStatus");
            DescribeConfigurationAggregatorSourcesStatusResponse describeConfigurationAggregatorSourcesStatusResponse = (DescribeConfigurationAggregatorSourcesStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationAggregatorSourcesStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConfigurationAggregatorSourcesStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConfigurationAggregatorSourcesStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConfigurationAggregatorSourcesStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeConfigurationAggregatorSourcesStatus$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigurationAggregatorsResponse describeConfigurationAggregators(DescribeConfigurationAggregatorsRequest describeConfigurationAggregatorsRequest) throws InvalidParameterValueException, NoSuchConfigurationAggregatorException, InvalidNextTokenException, InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigurationAggregatorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConfigurationAggregatorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeConfigurationAggregatorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConfigurationAggregators");
            DescribeConfigurationAggregatorsResponse describeConfigurationAggregatorsResponse = (DescribeConfigurationAggregatorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationAggregators").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConfigurationAggregatorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConfigurationAggregatorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConfigurationAggregatorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeConfigurationAggregators$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigurationRecorderStatusResponse describeConfigurationRecorderStatus(DescribeConfigurationRecorderStatusRequest describeConfigurationRecorderStatusRequest) throws NoSuchConfigurationRecorderException, ValidationException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigurationRecorderStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConfigurationRecorderStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeConfigurationRecorderStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConfigurationRecorderStatus");
            DescribeConfigurationRecorderStatusResponse describeConfigurationRecorderStatusResponse = (DescribeConfigurationRecorderStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationRecorderStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConfigurationRecorderStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConfigurationRecorderStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConfigurationRecorderStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeConfigurationRecorderStatus$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigurationRecordersResponse describeConfigurationRecorders(DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest) throws NoSuchConfigurationRecorderException, ValidationException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigurationRecordersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConfigurationRecordersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeConfigurationRecordersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConfigurationRecorders");
            DescribeConfigurationRecordersResponse describeConfigurationRecordersResponse = (DescribeConfigurationRecordersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurationRecorders").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConfigurationRecordersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConfigurationRecordersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConfigurationRecordersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeConfigurationRecorders$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConformancePackComplianceResponse describeConformancePackCompliance(DescribeConformancePackComplianceRequest describeConformancePackComplianceRequest) throws InvalidLimitException, InvalidNextTokenException, InvalidParameterValueException, NoSuchConfigRuleInConformancePackException, NoSuchConformancePackException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConformancePackComplianceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConformancePackComplianceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeConformancePackComplianceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConformancePackCompliance");
            DescribeConformancePackComplianceResponse describeConformancePackComplianceResponse = (DescribeConformancePackComplianceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConformancePackCompliance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConformancePackComplianceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConformancePackComplianceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConformancePackComplianceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeConformancePackCompliance$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConformancePackStatusResponse describeConformancePackStatus(DescribeConformancePackStatusRequest describeConformancePackStatusRequest) throws InvalidLimitException, InvalidNextTokenException, InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConformancePackStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConformancePackStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeConformancePackStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConformancePackStatus");
            DescribeConformancePackStatusResponse describeConformancePackStatusResponse = (DescribeConformancePackStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConformancePackStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConformancePackStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConformancePackStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConformancePackStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeConformancePackStatus$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConformancePacksResponse describeConformancePacks(DescribeConformancePacksRequest describeConformancePacksRequest) throws NoSuchConformancePackException, InvalidLimitException, InvalidNextTokenException, InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConformancePacksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConformancePacksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeConformancePacksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConformancePacks");
            DescribeConformancePacksResponse describeConformancePacksResponse = (DescribeConformancePacksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConformancePacks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConformancePacksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConformancePacksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConformancePacksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeConformancePacks$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDeliveryChannelStatusResponse describeDeliveryChannelStatus(DescribeDeliveryChannelStatusRequest describeDeliveryChannelStatusRequest) throws NoSuchDeliveryChannelException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDeliveryChannelStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDeliveryChannelStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeDeliveryChannelStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDeliveryChannelStatus");
            DescribeDeliveryChannelStatusResponse describeDeliveryChannelStatusResponse = (DescribeDeliveryChannelStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDeliveryChannelStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDeliveryChannelStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDeliveryChannelStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDeliveryChannelStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeDeliveryChannelStatus$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDeliveryChannelsResponse describeDeliveryChannels(DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest) throws NoSuchDeliveryChannelException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDeliveryChannelsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDeliveryChannelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeDeliveryChannelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDeliveryChannels");
            DescribeDeliveryChannelsResponse describeDeliveryChannelsResponse = (DescribeDeliveryChannelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDeliveryChannels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDeliveryChannelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDeliveryChannelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDeliveryChannelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeDeliveryChannels$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOrganizationConfigRuleStatusesResponse describeOrganizationConfigRuleStatuses(DescribeOrganizationConfigRuleStatusesRequest describeOrganizationConfigRuleStatusesRequest) throws NoSuchOrganizationConfigRuleException, InvalidLimitException, InvalidNextTokenException, OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationConfigRuleStatusesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeOrganizationConfigRuleStatusesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeOrganizationConfigRuleStatusesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrganizationConfigRuleStatuses");
            DescribeOrganizationConfigRuleStatusesResponse describeOrganizationConfigRuleStatusesResponse = (DescribeOrganizationConfigRuleStatusesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganizationConfigRuleStatuses").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeOrganizationConfigRuleStatusesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOrganizationConfigRuleStatusesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeOrganizationConfigRuleStatusesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeOrganizationConfigRuleStatuses$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOrganizationConfigRulesResponse describeOrganizationConfigRules(DescribeOrganizationConfigRulesRequest describeOrganizationConfigRulesRequest) throws NoSuchOrganizationConfigRuleException, InvalidNextTokenException, InvalidLimitException, OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationConfigRulesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeOrganizationConfigRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeOrganizationConfigRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrganizationConfigRules");
            DescribeOrganizationConfigRulesResponse describeOrganizationConfigRulesResponse = (DescribeOrganizationConfigRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganizationConfigRules").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeOrganizationConfigRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOrganizationConfigRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeOrganizationConfigRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeOrganizationConfigRules$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOrganizationConformancePackStatusesResponse describeOrganizationConformancePackStatuses(DescribeOrganizationConformancePackStatusesRequest describeOrganizationConformancePackStatusesRequest) throws NoSuchOrganizationConformancePackException, InvalidLimitException, InvalidNextTokenException, OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationConformancePackStatusesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeOrganizationConformancePackStatusesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeOrganizationConformancePackStatusesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrganizationConformancePackStatuses");
            DescribeOrganizationConformancePackStatusesResponse describeOrganizationConformancePackStatusesResponse = (DescribeOrganizationConformancePackStatusesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganizationConformancePackStatuses").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeOrganizationConformancePackStatusesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOrganizationConformancePackStatusesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeOrganizationConformancePackStatusesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeOrganizationConformancePackStatuses$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOrganizationConformancePacksResponse describeOrganizationConformancePacks(DescribeOrganizationConformancePacksRequest describeOrganizationConformancePacksRequest) throws NoSuchOrganizationConformancePackException, InvalidNextTokenException, InvalidLimitException, OrganizationAccessDeniedException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationConformancePacksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeOrganizationConformancePacksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeOrganizationConformancePacksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrganizationConformancePacks");
            DescribeOrganizationConformancePacksResponse describeOrganizationConformancePacksResponse = (DescribeOrganizationConformancePacksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganizationConformancePacks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeOrganizationConformancePacksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOrganizationConformancePacksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeOrganizationConformancePacksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeOrganizationConformancePacks$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePendingAggregationRequestsResponse describePendingAggregationRequests(DescribePendingAggregationRequestsRequest describePendingAggregationRequestsRequest) throws InvalidParameterValueException, InvalidNextTokenException, InvalidLimitException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePendingAggregationRequestsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describePendingAggregationRequestsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describePendingAggregationRequestsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePendingAggregationRequests");
            DescribePendingAggregationRequestsResponse describePendingAggregationRequestsResponse = (DescribePendingAggregationRequestsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePendingAggregationRequests").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describePendingAggregationRequestsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePendingAggregationRequestsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describePendingAggregationRequestsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describePendingAggregationRequests$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRemediationConfigurationsResponse describeRemediationConfigurations(DescribeRemediationConfigurationsRequest describeRemediationConfigurationsRequest) throws AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRemediationConfigurationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRemediationConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeRemediationConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRemediationConfigurations");
            DescribeRemediationConfigurationsResponse describeRemediationConfigurationsResponse = (DescribeRemediationConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRemediationConfigurations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeRemediationConfigurationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRemediationConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRemediationConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeRemediationConfigurations$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRemediationExceptionsResponse describeRemediationExceptions(DescribeRemediationExceptionsRequest describeRemediationExceptionsRequest) throws InvalidNextTokenException, InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRemediationExceptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRemediationExceptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeRemediationExceptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRemediationExceptions");
            DescribeRemediationExceptionsResponse describeRemediationExceptionsResponse = (DescribeRemediationExceptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRemediationExceptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeRemediationExceptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRemediationExceptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRemediationExceptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeRemediationExceptions$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRemediationExecutionStatusResponse describeRemediationExecutionStatus(DescribeRemediationExecutionStatusRequest describeRemediationExecutionStatusRequest) throws NoSuchRemediationConfigurationException, InvalidNextTokenException, InvalidParameterValueException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRemediationExecutionStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRemediationExecutionStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeRemediationExecutionStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRemediationExecutionStatus");
            DescribeRemediationExecutionStatusResponse describeRemediationExecutionStatusResponse = (DescribeRemediationExecutionStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRemediationExecutionStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeRemediationExecutionStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRemediationExecutionStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRemediationExecutionStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeRemediationExecutionStatus$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRetentionConfigurationsResponse describeRetentionConfigurations(DescribeRetentionConfigurationsRequest describeRetentionConfigurationsRequest) throws InvalidParameterValueException, NoSuchRetentionConfigurationException, InvalidNextTokenException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRetentionConfigurationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRetentionConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, describeRetentionConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRetentionConfigurations");
            DescribeRetentionConfigurationsResponse describeRetentionConfigurationsResponse = (DescribeRetentionConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRetentionConfigurations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeRetentionConfigurationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRetentionConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeRetentionConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$describeRetentionConfigurations$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateResourceTypesResponse disassociateResourceTypes(DisassociateResourceTypesRequest disassociateResourceTypesRequest) throws ValidationException, ConflictException, NoSuchConfigurationRecorderException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateResourceTypesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateResourceTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, disassociateResourceTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateResourceTypes");
            DisassociateResourceTypesResponse disassociateResourceTypesResponse = (DisassociateResourceTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateResourceTypes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateResourceTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateResourceTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateResourceTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$disassociateResourceTypes$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAggregateComplianceDetailsByConfigRuleResponse getAggregateComplianceDetailsByConfigRule(GetAggregateComplianceDetailsByConfigRuleRequest getAggregateComplianceDetailsByConfigRuleRequest) throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAggregateComplianceDetailsByConfigRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "IdempotentParameterMismatch": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                }
                case "NoSuchConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                }
                case "InsufficientPermissionsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                }
                case "InvalidSNSTopicARNException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                }
                case "MaxActiveResourcesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "NoSuchConfigRuleInConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder).build());
                }
                case "MaxNumberOfConfigurationRecordersExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                }
                case "NoSuchConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                }
                case "InvalidS3KmsKeyArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                }
                case "NoSuchBucketException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                }
                case "InvalidConfigurationRecorderNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "NoSuchConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                }
                case "InvalidRoleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRoleException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAggregateComplianceDetailsByConfigRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultConfigClient.resolveMetricPublishers(clientConfiguration, getAggregateComplianceDetailsByConfigRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAggregateComplianceDetailsByConfigRule");
            GetAggregateComplianceDetailsByConfigRuleResponse getAggregateComplianceDetailsByConfigRuleResponse = (GetAggregateComplianceDetailsByConfigRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAggregateComplianceDetailsByConfigRule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAggregateComplianceDetailsByConfigRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAggregateComplianceDetailsByConfigRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAggregateComplianceDetailsByConfigRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConfigClient.lambda$getAggregateComplianceDetailsByConfigRule$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAggregateConfigRuleComplianceSummaryResponse getAggregateConfigRuleComplianceSummary(GetAggregateConfigRuleComplianceSummaryRequest getAggregateConfigRuleComplianceSummaryRequest) throws ValidationException, InvalidLimitException, InvalidNextTokenException, NoSuchConfigurationAggregatorException, AwsServiceException, SdkClientException, ConfigException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAggregateConfigRuleComplianceSummaryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NoRunningConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder).build());
                }
                case "OrganizationConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                }
                case "UnmodifiableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                }
                case "NoSuchRetentionConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder).build());
                }
                case "ResourceConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder).build());
                }
                case "NoSuchConfigurationAggregatorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder).build());
                }
                case "RemediationInProgressException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                }
                case "NoAvailableConfigurationRecorderException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "OrganizationAllFeaturesNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder).build());
                }
                case "InvalidLimitException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLimitException::builder).build());
                }
                case "NoSuchOrganizationConfigRuleException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder).build());
                }
                case "MaxNumberOfDeliveryChannelsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "MaxNumberOfConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder).build());
                }
                case "InvalidExpressionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                }
                case "NoSuchOrganizationConformancePackException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder).build());
                }
                case "MaxNumberOfConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder).build());
                }
                case "MaxNumberOfOrganizationConfigRulesExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRecordingGroupException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "TooManyTagsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                }
                case "MaxNumberOfRetentionConfigurationsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                }
                case "InvalidDeliveryChannelNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                }
                case "ConformancePackTemplateValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder).build());
                }
                case "MaxNumberOfOrganizationConformancePacksExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                }
                case "InvalidS3KeyPrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                }
                case "ResourceNotDiscoveredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                }
                case "NoSuchRemediationConfigurationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder).build());
                }
                case "NoAvailableDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                }
                case "NoSuchRemediationExceptionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                }
                case "InvalidResultTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                }
                case "OversizedConfigurationItemException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                }
                case "InsufficientDeliveryPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                }
                case "OrganizationAccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                }
                case "NoAvailableOrganizationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                }
                case "NoSuchDeliveryChannelException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                }
                case "LastDeliveryChannelDeleteFailedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException").