/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigurationRecorderFilterName;
import software.amazon.awssdk.services.config.model.ConfigurationRecorderFilterValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationRecorderFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationRecorderFilter> {
    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterName").getter(ConfigurationRecorderFilter.getter(ConfigurationRecorderFilter::filterNameAsString)).setter(ConfigurationRecorderFilter.setter(Builder::filterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterName").build()}).build();
    private static final SdkField<List<String>> FILTER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filterValue").getter(ConfigurationRecorderFilter.getter(ConfigurationRecorderFilter::filterValue)).setter(ConfigurationRecorderFilter.setter(Builder::filterValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterValue").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_NAME_FIELD, FILTER_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurationRecorderFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String filterName;
    private final List<String> filterValue;

    private ConfigurationRecorderFilter(BuilderImpl builder) {
        this.filterName = builder.filterName;
        this.filterValue = builder.filterValue;
    }

    public final ConfigurationRecorderFilterName filterName() {
        return ConfigurationRecorderFilterName.fromValue(this.filterName);
    }

    public final String filterNameAsString() {
        return this.filterName;
    }

    public final boolean hasFilterValue() {
        return this.filterValue != null && !(this.filterValue instanceof SdkAutoConstructList);
    }

    public final List<String> filterValue() {
        return this.filterValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterValue() ? this.filterValue() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationRecorderFilter)) {
            return false;
        }
        ConfigurationRecorderFilter other = (ConfigurationRecorderFilter)obj;
        return Objects.equals(this.filterNameAsString(), other.filterNameAsString()) && this.hasFilterValue() == other.hasFilterValue() && Objects.equals(this.filterValue(), other.filterValue());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationRecorderFilter").add("FilterName", (Object)this.filterNameAsString()).add("FilterValue", this.hasFilterValue() ? this.filterValue() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterName": {
                return Optional.ofNullable(clazz.cast(this.filterNameAsString()));
            }
            case "filterValue": {
                return Optional.ofNullable(clazz.cast(this.filterValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filterName", FILTER_NAME_FIELD);
        map.put("filterValue", FILTER_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationRecorderFilter, T> g) {
        return obj -> g.apply((ConfigurationRecorderFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterName;
        private List<String> filterValue = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationRecorderFilter model) {
            this.filterName(model.filterName);
            this.filterValue(model.filterValue);
        }

        public final String getFilterName() {
            return this.filterName;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        @Override
        public final Builder filterName(ConfigurationRecorderFilterName filterName) {
            this.filterName(filterName == null ? null : filterName.toString());
            return this;
        }

        public final Collection<String> getFilterValue() {
            if (this.filterValue instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterValue;
        }

        public final void setFilterValue(Collection<String> filterValue) {
            this.filterValue = ConfigurationRecorderFilterValuesCopier.copy(filterValue);
        }

        @Override
        public final Builder filterValue(Collection<String> filterValue) {
            this.filterValue = ConfigurationRecorderFilterValuesCopier.copy(filterValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterValue(String ... filterValue) {
            this.filterValue(Arrays.asList(filterValue));
            return this;
        }

        public ConfigurationRecorderFilter build() {
            return new ConfigurationRecorderFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationRecorderFilter> {
        public Builder filterName(String var1);

        public Builder filterName(ConfigurationRecorderFilterName var1);

        public Builder filterValue(Collection<String> var1);

        public Builder filterValue(String ... var1);
    }
}

