/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ExclusionByResourceTypes;
import software.amazon.awssdk.services.config.model.RecordingStrategy;
import software.amazon.awssdk.services.config.model.ResourceType;
import software.amazon.awssdk.services.config.model.ResourceTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecordingGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecordingGroup> {
    private static final SdkField<Boolean> ALL_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allSupported").getter(RecordingGroup.getter(RecordingGroup::allSupported)).setter(RecordingGroup.setter(Builder::allSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allSupported").build()}).build();
    private static final SdkField<Boolean> INCLUDE_GLOBAL_RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeGlobalResourceTypes").getter(RecordingGroup.getter(RecordingGroup::includeGlobalResourceTypes)).setter(RecordingGroup.setter(Builder::includeGlobalResourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeGlobalResourceTypes").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceTypes").getter(RecordingGroup.getter(RecordingGroup::resourceTypesAsStrings)).setter(RecordingGroup.setter(Builder::resourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ExclusionByResourceTypes> EXCLUSION_BY_RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("exclusionByResourceTypes").getter(RecordingGroup.getter(RecordingGroup::exclusionByResourceTypes)).setter(RecordingGroup.setter(Builder::exclusionByResourceTypes)).constructor(ExclusionByResourceTypes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exclusionByResourceTypes").build()}).build();
    private static final SdkField<RecordingStrategy> RECORDING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recordingStrategy").getter(RecordingGroup.getter(RecordingGroup::recordingStrategy)).setter(RecordingGroup.setter(Builder::recordingStrategy)).constructor(RecordingStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_SUPPORTED_FIELD, INCLUDE_GLOBAL_RESOURCE_TYPES_FIELD, RESOURCE_TYPES_FIELD, EXCLUSION_BY_RESOURCE_TYPES_FIELD, RECORDING_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecordingGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean allSupported;
    private final Boolean includeGlobalResourceTypes;
    private final List<String> resourceTypes;
    private final ExclusionByResourceTypes exclusionByResourceTypes;
    private final RecordingStrategy recordingStrategy;

    private RecordingGroup(BuilderImpl builder) {
        this.allSupported = builder.allSupported;
        this.includeGlobalResourceTypes = builder.includeGlobalResourceTypes;
        this.resourceTypes = builder.resourceTypes;
        this.exclusionByResourceTypes = builder.exclusionByResourceTypes;
        this.recordingStrategy = builder.recordingStrategy;
    }

    public final Boolean allSupported() {
        return this.allSupported;
    }

    public final Boolean includeGlobalResourceTypes() {
        return this.includeGlobalResourceTypes;
    }

    public final List<ResourceType> resourceTypes() {
        return ResourceTypeListCopier.copyStringToEnum(this.resourceTypes);
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypesAsStrings() {
        return this.resourceTypes;
    }

    public final ExclusionByResourceTypes exclusionByResourceTypes() {
        return this.exclusionByResourceTypes;
    }

    public final RecordingStrategy recordingStrategy() {
        return this.recordingStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allSupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeGlobalResourceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusionByResourceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingStrategy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordingGroup)) {
            return false;
        }
        RecordingGroup other = (RecordingGroup)obj;
        return Objects.equals(this.allSupported(), other.allSupported()) && Objects.equals(this.includeGlobalResourceTypes(), other.includeGlobalResourceTypes()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypesAsStrings(), other.resourceTypesAsStrings()) && Objects.equals(this.exclusionByResourceTypes(), other.exclusionByResourceTypes()) && Objects.equals(this.recordingStrategy(), other.recordingStrategy());
    }

    public final String toString() {
        return ToString.builder((String)"RecordingGroup").add("AllSupported", (Object)this.allSupported()).add("IncludeGlobalResourceTypes", (Object)this.includeGlobalResourceTypes()).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypesAsStrings() : null).add("ExclusionByResourceTypes", (Object)this.exclusionByResourceTypes()).add("RecordingStrategy", (Object)this.recordingStrategy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allSupported": {
                return Optional.ofNullable(clazz.cast(this.allSupported()));
            }
            case "includeGlobalResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.includeGlobalResourceTypes()));
            }
            case "resourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypesAsStrings()));
            }
            case "exclusionByResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.exclusionByResourceTypes()));
            }
            case "recordingStrategy": {
                return Optional.ofNullable(clazz.cast(this.recordingStrategy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("allSupported", ALL_SUPPORTED_FIELD);
        map.put("includeGlobalResourceTypes", INCLUDE_GLOBAL_RESOURCE_TYPES_FIELD);
        map.put("resourceTypes", RESOURCE_TYPES_FIELD);
        map.put("exclusionByResourceTypes", EXCLUSION_BY_RESOURCE_TYPES_FIELD);
        map.put("recordingStrategy", RECORDING_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecordingGroup, T> g) {
        return obj -> g.apply((RecordingGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean allSupported;
        private Boolean includeGlobalResourceTypes;
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private ExclusionByResourceTypes exclusionByResourceTypes;
        private RecordingStrategy recordingStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordingGroup model) {
            this.allSupported(model.allSupported);
            this.includeGlobalResourceTypes(model.includeGlobalResourceTypes);
            this.resourceTypesWithStrings(model.resourceTypes);
            this.exclusionByResourceTypes(model.exclusionByResourceTypes);
            this.recordingStrategy(model.recordingStrategy);
        }

        public final Boolean getAllSupported() {
            return this.allSupported;
        }

        public final void setAllSupported(Boolean allSupported) {
            this.allSupported = allSupported;
        }

        @Override
        public final Builder allSupported(Boolean allSupported) {
            this.allSupported = allSupported;
            return this;
        }

        public final Boolean getIncludeGlobalResourceTypes() {
            return this.includeGlobalResourceTypes;
        }

        public final void setIncludeGlobalResourceTypes(Boolean includeGlobalResourceTypes) {
            this.includeGlobalResourceTypes = includeGlobalResourceTypes;
        }

        @Override
        public final Builder includeGlobalResourceTypes(Boolean includeGlobalResourceTypes) {
            this.includeGlobalResourceTypes = includeGlobalResourceTypes;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String ... resourceTypes) {
            this.resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceType> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceType ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final ExclusionByResourceTypes.Builder getExclusionByResourceTypes() {
            return this.exclusionByResourceTypes != null ? this.exclusionByResourceTypes.toBuilder() : null;
        }

        public final void setExclusionByResourceTypes(ExclusionByResourceTypes.BuilderImpl exclusionByResourceTypes) {
            this.exclusionByResourceTypes = exclusionByResourceTypes != null ? exclusionByResourceTypes.build() : null;
        }

        @Override
        public final Builder exclusionByResourceTypes(ExclusionByResourceTypes exclusionByResourceTypes) {
            this.exclusionByResourceTypes = exclusionByResourceTypes;
            return this;
        }

        public final RecordingStrategy.Builder getRecordingStrategy() {
            return this.recordingStrategy != null ? this.recordingStrategy.toBuilder() : null;
        }

        public final void setRecordingStrategy(RecordingStrategy.BuilderImpl recordingStrategy) {
            this.recordingStrategy = recordingStrategy != null ? recordingStrategy.build() : null;
        }

        @Override
        public final Builder recordingStrategy(RecordingStrategy recordingStrategy) {
            this.recordingStrategy = recordingStrategy;
            return this;
        }

        public RecordingGroup build() {
            return new RecordingGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecordingGroup> {
        public Builder allSupported(Boolean var1);

        public Builder includeGlobalResourceTypes(Boolean var1);

        public Builder resourceTypesWithStrings(Collection<String> var1);

        public Builder resourceTypesWithStrings(String ... var1);

        public Builder resourceTypes(Collection<ResourceType> var1);

        public Builder resourceTypes(ResourceType ... var1);

        public Builder exclusionByResourceTypes(ExclusionByResourceTypes var1);

        default public Builder exclusionByResourceTypes(Consumer<ExclusionByResourceTypes.Builder> exclusionByResourceTypes) {
            return this.exclusionByResourceTypes((ExclusionByResourceTypes)((ExclusionByResourceTypes.Builder)ExclusionByResourceTypes.builder().applyMutation(exclusionByResourceTypes)).build());
        }

        public Builder recordingStrategy(RecordingStrategy var1);

        default public Builder recordingStrategy(Consumer<RecordingStrategy.Builder> recordingStrategy) {
            return this.recordingStrategy((RecordingStrategy)((RecordingStrategy.Builder)RecordingStrategy.builder().applyMutation(recordingStrategy)).build());
        }
    }
}

