/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.EvaluationResult;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse;

public class GetComplianceDetailsByResourcePublisher
implements SdkPublisher<GetComplianceDetailsByResourceResponse> {
    private final ConfigAsyncClient client;
    private final GetComplianceDetailsByResourceRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetComplianceDetailsByResourcePublisher(ConfigAsyncClient client, GetComplianceDetailsByResourceRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetComplianceDetailsByResourcePublisher(ConfigAsyncClient client, GetComplianceDetailsByResourceRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetComplianceDetailsByResourceResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetComplianceDetailsByResourceResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EvaluationResult> evaluationResults() {
        Function<GetComplianceDetailsByResourceResponse, Iterator> getIterator = response -> {
            if (response != null && response.evaluationResults() != null) {
                return response.evaluationResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetComplianceDetailsByResourceResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetComplianceDetailsByResourceResponseFetcher
    implements AsyncPageFetcher<GetComplianceDetailsByResourceResponse> {
        private GetComplianceDetailsByResourceResponseFetcher() {
        }

        public boolean hasNextPage(GetComplianceDetailsByResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetComplianceDetailsByResourceResponse> nextPage(GetComplianceDetailsByResourceResponse previousPage) {
            if (previousPage == null) {
                return GetComplianceDetailsByResourcePublisher.this.client.getComplianceDetailsByResource(GetComplianceDetailsByResourcePublisher.this.firstRequest);
            }
            return GetComplianceDetailsByResourcePublisher.this.client.getComplianceDetailsByResource((GetComplianceDetailsByResourceRequest)((Object)GetComplianceDetailsByResourcePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

