/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Enable persistent chats. For more information about enabling persistent chat, and for example use cases and how to
 * configure for them, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html">Enable
 * persistent chat</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PersistentChat implements SdkPojo, Serializable, ToCopyableBuilder<PersistentChat.Builder, PersistentChat> {
    private static final SdkField<String> REHYDRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RehydrationType").getter(getter(PersistentChat::rehydrationTypeAsString))
            .setter(setter(Builder::rehydrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RehydrationType").build()).build();

    private static final SdkField<String> SOURCE_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceContactId").getter(getter(PersistentChat::sourceContactId))
            .setter(setter(Builder::sourceContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceContactId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REHYDRATION_TYPE_FIELD,
            SOURCE_CONTACT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String rehydrationType;

    private final String sourceContactId;

    private PersistentChat(BuilderImpl builder) {
        this.rehydrationType = builder.rehydrationType;
        this.sourceContactId = builder.sourceContactId;
    }

    /**
     * <p>
     * The contactId that is used for rehydration depends on the rehydration type. RehydrationType is required for
     * persistent chat.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENTIRE_PAST_SESSION</code>: Rehydrates a chat from the most recently terminated past chat contact of the
     * specified past ended chat session. To use this type, provide the <code>initialContactId</code> of the past ended
     * chat session in the <code>sourceContactId</code> field. In this type, Amazon Connect determines the most recent
     * chat contact on the specified chat session that has ended, and uses it to start a persistent chat.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FROM_SEGMENT</code>: Rehydrates a chat from the past chat contact that is specified in the
     * <code>sourceContactId</code> field.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The actual contactId used for rehydration is provided in the response of this API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rehydrationType}
     * will return {@link RehydrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rehydrationTypeAsString}.
     * </p>
     * 
     * @return The contactId that is used for rehydration depends on the rehydration type. RehydrationType is required
     *         for persistent chat. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENTIRE_PAST_SESSION</code>: Rehydrates a chat from the most recently terminated past chat contact
     *         of the specified past ended chat session. To use this type, provide the <code>initialContactId</code> of
     *         the past ended chat session in the <code>sourceContactId</code> field. In this type, Amazon Connect
     *         determines the most recent chat contact on the specified chat session that has ended, and uses it to
     *         start a persistent chat.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FROM_SEGMENT</code>: Rehydrates a chat from the past chat contact that is specified in the
     *         <code>sourceContactId</code> field.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The actual contactId used for rehydration is provided in the response of this API.
     * @see RehydrationType
     */
    public final RehydrationType rehydrationType() {
        return RehydrationType.fromValue(rehydrationType);
    }

    /**
     * <p>
     * The contactId that is used for rehydration depends on the rehydration type. RehydrationType is required for
     * persistent chat.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENTIRE_PAST_SESSION</code>: Rehydrates a chat from the most recently terminated past chat contact of the
     * specified past ended chat session. To use this type, provide the <code>initialContactId</code> of the past ended
     * chat session in the <code>sourceContactId</code> field. In this type, Amazon Connect determines the most recent
     * chat contact on the specified chat session that has ended, and uses it to start a persistent chat.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FROM_SEGMENT</code>: Rehydrates a chat from the past chat contact that is specified in the
     * <code>sourceContactId</code> field.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The actual contactId used for rehydration is provided in the response of this API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rehydrationType}
     * will return {@link RehydrationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rehydrationTypeAsString}.
     * </p>
     * 
     * @return The contactId that is used for rehydration depends on the rehydration type. RehydrationType is required
     *         for persistent chat. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENTIRE_PAST_SESSION</code>: Rehydrates a chat from the most recently terminated past chat contact
     *         of the specified past ended chat session. To use this type, provide the <code>initialContactId</code> of
     *         the past ended chat session in the <code>sourceContactId</code> field. In this type, Amazon Connect
     *         determines the most recent chat contact on the specified chat session that has ended, and uses it to
     *         start a persistent chat.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FROM_SEGMENT</code>: Rehydrates a chat from the past chat contact that is specified in the
     *         <code>sourceContactId</code> field.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The actual contactId used for rehydration is provided in the response of this API.
     * @see RehydrationType
     */
    public final String rehydrationTypeAsString() {
        return rehydrationType;
    }

    /**
     * <p>
     * The contactId from which a persistent chat session must be started.
     * </p>
     * 
     * @return The contactId from which a persistent chat session must be started.
     */
    public final String sourceContactId() {
        return sourceContactId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rehydrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceContactId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PersistentChat)) {
            return false;
        }
        PersistentChat other = (PersistentChat) obj;
        return Objects.equals(rehydrationTypeAsString(), other.rehydrationTypeAsString())
                && Objects.equals(sourceContactId(), other.sourceContactId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PersistentChat").add("RehydrationType", rehydrationTypeAsString())
                .add("SourceContactId", sourceContactId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RehydrationType":
            return Optional.ofNullable(clazz.cast(rehydrationTypeAsString()));
        case "SourceContactId":
            return Optional.ofNullable(clazz.cast(sourceContactId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PersistentChat, T> g) {
        return obj -> g.apply((PersistentChat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PersistentChat> {
        /**
         * <p>
         * The contactId that is used for rehydration depends on the rehydration type. RehydrationType is required for
         * persistent chat.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENTIRE_PAST_SESSION</code>: Rehydrates a chat from the most recently terminated past chat contact of
         * the specified past ended chat session. To use this type, provide the <code>initialContactId</code> of the
         * past ended chat session in the <code>sourceContactId</code> field. In this type, Amazon Connect determines
         * the most recent chat contact on the specified chat session that has ended, and uses it to start a persistent
         * chat.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FROM_SEGMENT</code>: Rehydrates a chat from the past chat contact that is specified in the
         * <code>sourceContactId</code> field.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The actual contactId used for rehydration is provided in the response of this API.
         * </p>
         * 
         * @param rehydrationType
         *        The contactId that is used for rehydration depends on the rehydration type. RehydrationType is
         *        required for persistent chat. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENTIRE_PAST_SESSION</code>: Rehydrates a chat from the most recently terminated past chat
         *        contact of the specified past ended chat session. To use this type, provide the
         *        <code>initialContactId</code> of the past ended chat session in the <code>sourceContactId</code>
         *        field. In this type, Amazon Connect determines the most recent chat contact on the specified chat
         *        session that has ended, and uses it to start a persistent chat.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FROM_SEGMENT</code>: Rehydrates a chat from the past chat contact that is specified in the
         *        <code>sourceContactId</code> field.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The actual contactId used for rehydration is provided in the response of this API.
         * @see RehydrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RehydrationType
         */
        Builder rehydrationType(String rehydrationType);

        /**
         * <p>
         * The contactId that is used for rehydration depends on the rehydration type. RehydrationType is required for
         * persistent chat.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENTIRE_PAST_SESSION</code>: Rehydrates a chat from the most recently terminated past chat contact of
         * the specified past ended chat session. To use this type, provide the <code>initialContactId</code> of the
         * past ended chat session in the <code>sourceContactId</code> field. In this type, Amazon Connect determines
         * the most recent chat contact on the specified chat session that has ended, and uses it to start a persistent
         * chat.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FROM_SEGMENT</code>: Rehydrates a chat from the past chat contact that is specified in the
         * <code>sourceContactId</code> field.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The actual contactId used for rehydration is provided in the response of this API.
         * </p>
         * 
         * @param rehydrationType
         *        The contactId that is used for rehydration depends on the rehydration type. RehydrationType is
         *        required for persistent chat. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENTIRE_PAST_SESSION</code>: Rehydrates a chat from the most recently terminated past chat
         *        contact of the specified past ended chat session. To use this type, provide the
         *        <code>initialContactId</code> of the past ended chat session in the <code>sourceContactId</code>
         *        field. In this type, Amazon Connect determines the most recent chat contact on the specified chat
         *        session that has ended, and uses it to start a persistent chat.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FROM_SEGMENT</code>: Rehydrates a chat from the past chat contact that is specified in the
         *        <code>sourceContactId</code> field.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The actual contactId used for rehydration is provided in the response of this API.
         * @see RehydrationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RehydrationType
         */
        Builder rehydrationType(RehydrationType rehydrationType);

        /**
         * <p>
         * The contactId from which a persistent chat session must be started.
         * </p>
         * 
         * @param sourceContactId
         *        The contactId from which a persistent chat session must be started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceContactId(String sourceContactId);
    }

    static final class BuilderImpl implements Builder {
        private String rehydrationType;

        private String sourceContactId;

        private BuilderImpl() {
        }

        private BuilderImpl(PersistentChat model) {
            rehydrationType(model.rehydrationType);
            sourceContactId(model.sourceContactId);
        }

        public final String getRehydrationType() {
            return rehydrationType;
        }

        public final void setRehydrationType(String rehydrationType) {
            this.rehydrationType = rehydrationType;
        }

        @Override
        public final Builder rehydrationType(String rehydrationType) {
            this.rehydrationType = rehydrationType;
            return this;
        }

        @Override
        public final Builder rehydrationType(RehydrationType rehydrationType) {
            this.rehydrationType(rehydrationType == null ? null : rehydrationType.toString());
            return this;
        }

        public final String getSourceContactId() {
            return sourceContactId;
        }

        public final void setSourceContactId(String sourceContactId) {
            this.sourceContactId = sourceContactId;
        }

        @Override
        public final Builder sourceContactId(String sourceContactId) {
            this.sourceContactId = sourceContactId;
            return this;
        }

        @Override
        public PersistentChat build() {
            return new PersistentChat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
