/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.DataSetIdsCopier;
import software.amazon.awssdk.services.connect.model.ErrorResult;
import software.amazon.awssdk.services.connect.model.ErrorResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDisassociateAnalyticsDataSetResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, BatchDisassociateAnalyticsDataSetResponse> {
    private static final SdkField<List<String>> DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Deleted").getter(BatchDisassociateAnalyticsDataSetResponse.getter(BatchDisassociateAnalyticsDataSetResponse::deleted)).setter(BatchDisassociateAnalyticsDataSetResponse.setter(Builder::deleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deleted").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ErrorResult>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchDisassociateAnalyticsDataSetResponse.getter(BatchDisassociateAnalyticsDataSetResponse::errors)).setter(BatchDisassociateAnalyticsDataSetResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETED_FIELD, ERRORS_FIELD));
    private final List<String> deleted;
    private final List<ErrorResult> errors;

    private BatchDisassociateAnalyticsDataSetResponse(BuilderImpl builder) {
        super(builder);
        this.deleted = builder.deleted;
        this.errors = builder.errors;
    }

    public final boolean hasDeleted() {
        return this.deleted != null && !(this.deleted instanceof SdkAutoConstructList);
    }

    public final List<String> deleted() {
        return this.deleted;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<ErrorResult> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeleted() ? this.deleted() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisassociateAnalyticsDataSetResponse)) {
            return false;
        }
        BatchDisassociateAnalyticsDataSetResponse other = (BatchDisassociateAnalyticsDataSetResponse)((Object)obj);
        return this.hasDeleted() == other.hasDeleted() && Objects.equals(this.deleted(), other.deleted()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDisassociateAnalyticsDataSetResponse").add("Deleted", this.hasDeleted() ? this.deleted() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Deleted": {
                return Optional.ofNullable(clazz.cast(this.deleted()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDisassociateAnalyticsDataSetResponse, T> g) {
        return obj -> g.apply((BatchDisassociateAnalyticsDataSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<String> deleted = DefaultSdkAutoConstructList.getInstance();
        private List<ErrorResult> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisassociateAnalyticsDataSetResponse model) {
            super(model);
            this.deleted(model.deleted);
            this.errors(model.errors);
        }

        public final Collection<String> getDeleted() {
            if (this.deleted instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deleted;
        }

        public final void setDeleted(Collection<String> deleted) {
            this.deleted = DataSetIdsCopier.copy(deleted);
        }

        @Override
        public final Builder deleted(Collection<String> deleted) {
            this.deleted = DataSetIdsCopier.copy(deleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleted(String ... deleted) {
            this.deleted(Arrays.asList(deleted));
            return this;
        }

        public final List<ErrorResult.Builder> getErrors() {
            List<ErrorResult.Builder> result = ErrorResultsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<ErrorResult.BuilderImpl> errors) {
            this.errors = ErrorResultsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<ErrorResult> errors) {
            this.errors = ErrorResultsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(ErrorResult ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<ErrorResult.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (ErrorResult)((ErrorResult.Builder)ErrorResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDisassociateAnalyticsDataSetResponse build() {
            return new BatchDisassociateAnalyticsDataSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDisassociateAnalyticsDataSetResponse> {
        public Builder deleted(Collection<String> var1);

        public Builder deleted(String ... var1);

        public Builder errors(Collection<ErrorResult> var1);

        public Builder errors(ErrorResult ... var1);

        public Builder errors(Consumer<ErrorResult.Builder> ... var1);
    }
}

