/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.RuleAction;
import software.amazon.awssdk.services.connect.model.RuleActionsCopier;
import software.amazon.awssdk.services.connect.model.RulePublishStatus;
import software.amazon.awssdk.services.connect.model.RuleTriggerEventSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRuleRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, CreateRuleRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(CreateRuleRequest.getter(CreateRuleRequest::instanceId)).setter(CreateRuleRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateRuleRequest.getter(CreateRuleRequest::name)).setter(CreateRuleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<RuleTriggerEventSource> TRIGGER_EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TriggerEventSource").getter(CreateRuleRequest.getter(CreateRuleRequest::triggerEventSource)).setter(CreateRuleRequest.setter(Builder::triggerEventSource)).constructor(RuleTriggerEventSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerEventSource").build()}).build();
    private static final SdkField<String> FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Function").getter(CreateRuleRequest.getter(CreateRuleRequest::function)).setter(CreateRuleRequest.setter(Builder::function)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Function").build()}).build();
    private static final SdkField<List<RuleAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(CreateRuleRequest.getter(CreateRuleRequest::actions)).setter(CreateRuleRequest.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PUBLISH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublishStatus").getter(CreateRuleRequest.getter(CreateRuleRequest::publishStatusAsString)).setter(CreateRuleRequest.setter(Builder::publishStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishStatus").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateRuleRequest.getter(CreateRuleRequest::clientToken)).setter(CreateRuleRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NAME_FIELD, TRIGGER_EVENT_SOURCE_FIELD, FUNCTION_FIELD, ACTIONS_FIELD, PUBLISH_STATUS_FIELD, CLIENT_TOKEN_FIELD));
    private final String instanceId;
    private final String name;
    private final RuleTriggerEventSource triggerEventSource;
    private final String function;
    private final List<RuleAction> actions;
    private final String publishStatus;
    private final String clientToken;

    private CreateRuleRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.triggerEventSource = builder.triggerEventSource;
        this.function = builder.function;
        this.actions = builder.actions;
        this.publishStatus = builder.publishStatus;
        this.clientToken = builder.clientToken;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String name() {
        return this.name;
    }

    public final RuleTriggerEventSource triggerEventSource() {
        return this.triggerEventSource;
    }

    public final String function() {
        return this.function;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<RuleAction> actions() {
        return this.actions;
    }

    public final RulePublishStatus publishStatus() {
        return RulePublishStatus.fromValue(this.publishStatus);
    }

    public final String publishStatusAsString() {
        return this.publishStatus;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerEventSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.function());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publishStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleRequest)) {
            return false;
        }
        CreateRuleRequest other = (CreateRuleRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.triggerEventSource(), other.triggerEventSource()) && Objects.equals(this.function(), other.function()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.publishStatusAsString(), other.publishStatusAsString()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRuleRequest").add("InstanceId", (Object)this.instanceId()).add("Name", (Object)this.name()).add("TriggerEventSource", (Object)this.triggerEventSource()).add("Function", (Object)this.function()).add("Actions", this.hasActions() ? this.actions() : null).add("PublishStatus", (Object)this.publishStatusAsString()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TriggerEventSource": {
                return Optional.ofNullable(clazz.cast(this.triggerEventSource()));
            }
            case "Function": {
                return Optional.ofNullable(clazz.cast(this.function()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "PublishStatus": {
                return Optional.ofNullable(clazz.cast(this.publishStatusAsString()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleRequest, T> g) {
        return obj -> g.apply((CreateRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String name;
        private RuleTriggerEventSource triggerEventSource;
        private String function;
        private List<RuleAction> actions = DefaultSdkAutoConstructList.getInstance();
        private String publishStatus;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.name(model.name);
            this.triggerEventSource(model.triggerEventSource);
            this.function(model.function);
            this.actions(model.actions);
            this.publishStatus(model.publishStatus);
            this.clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RuleTriggerEventSource.Builder getTriggerEventSource() {
            return this.triggerEventSource != null ? this.triggerEventSource.toBuilder() : null;
        }

        public final void setTriggerEventSource(RuleTriggerEventSource.BuilderImpl triggerEventSource) {
            this.triggerEventSource = triggerEventSource != null ? triggerEventSource.build() : null;
        }

        @Override
        public final Builder triggerEventSource(RuleTriggerEventSource triggerEventSource) {
            this.triggerEventSource = triggerEventSource;
            return this;
        }

        public final String getFunction() {
            return this.function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        public final List<RuleAction.Builder> getActions() {
            List<RuleAction.Builder> result = RuleActionsCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<RuleAction.BuilderImpl> actions) {
            this.actions = RuleActionsCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<RuleAction> actions) {
            this.actions = RuleActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(RuleAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<RuleAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (RuleAction)((RuleAction.Builder)RuleAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPublishStatus() {
            return this.publishStatus;
        }

        public final void setPublishStatus(String publishStatus) {
            this.publishStatus = publishStatus;
        }

        @Override
        public final Builder publishStatus(String publishStatus) {
            this.publishStatus = publishStatus;
            return this;
        }

        @Override
        public final Builder publishStatus(RulePublishStatus publishStatus) {
            this.publishStatus(publishStatus == null ? null : publishStatus.toString());
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRuleRequest build() {
            return new CreateRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRuleRequest> {
        public Builder instanceId(String var1);

        public Builder name(String var1);

        public Builder triggerEventSource(RuleTriggerEventSource var1);

        default public Builder triggerEventSource(Consumer<RuleTriggerEventSource.Builder> triggerEventSource) {
            return this.triggerEventSource((RuleTriggerEventSource)((RuleTriggerEventSource.Builder)RuleTriggerEventSource.builder().applyMutation(triggerEventSource)).build());
        }

        public Builder function(String var1);

        public Builder actions(Collection<RuleAction> var1);

        public Builder actions(RuleAction ... var1);

        public Builder actions(Consumer<RuleAction.Builder> ... var1);

        public Builder publishStatus(String var1);

        public Builder publishStatus(RulePublishStatus var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

