/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.FlowAssociationSummary;
import software.amazon.awssdk.services.connect.model.ListFlowAssociationsRequest;
import software.amazon.awssdk.services.connect.model.ListFlowAssociationsResponse;

public class ListFlowAssociationsPublisher
implements SdkPublisher<ListFlowAssociationsResponse> {
    private final ConnectAsyncClient client;
    private final ListFlowAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFlowAssociationsPublisher(ConnectAsyncClient client, ListFlowAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFlowAssociationsPublisher(ConnectAsyncClient client, ListFlowAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFlowAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFlowAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FlowAssociationSummary> flowAssociationSummaryList() {
        Function<ListFlowAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowAssociationSummaryList() != null) {
                return response.flowAssociationSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFlowAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFlowAssociationsResponseFetcher
    implements AsyncPageFetcher<ListFlowAssociationsResponse> {
        private ListFlowAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFlowAssociationsResponse> nextPage(ListFlowAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowAssociationsPublisher.this.client.listFlowAssociations(ListFlowAssociationsPublisher.this.firstRequest);
            }
            return ListFlowAssociationsPublisher.this.client.listFlowAssociations((ListFlowAssociationsRequest)((Object)ListFlowAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

