/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesRequest;
import software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesResponse;
import software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfigSummary;

public class ListRoutingProfileQueuesIterable
implements SdkIterable<ListRoutingProfileQueuesResponse> {
    private final ConnectClient client;
    private final ListRoutingProfileQueuesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRoutingProfileQueuesIterable(ConnectClient client, ListRoutingProfileQueuesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRoutingProfileQueuesResponseFetcher();
    }

    public Iterator<ListRoutingProfileQueuesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RoutingProfileQueueConfigSummary> routingProfileQueueConfigSummaryList() {
        Function<ListRoutingProfileQueuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.routingProfileQueueConfigSummaryList() != null) {
                return response.routingProfileQueueConfigSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRoutingProfileQueuesResponseFetcher
    implements SyncPageFetcher<ListRoutingProfileQueuesResponse> {
        private ListRoutingProfileQueuesResponseFetcher() {
        }

        public boolean hasNextPage(ListRoutingProfileQueuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRoutingProfileQueuesResponse nextPage(ListRoutingProfileQueuesResponse previousPage) {
            if (previousPage == null) {
                return ListRoutingProfileQueuesIterable.this.client.listRoutingProfileQueues(ListRoutingProfileQueuesIterable.this.firstRequest);
            }
            return ListRoutingProfileQueuesIterable.this.client.listRoutingProfileQueues((ListRoutingProfileQueuesRequest)((Object)ListRoutingProfileQueuesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

