/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.BatchPutFieldOptionsRequestOptionsListCopier;
import software.amazon.awssdk.services.connectcases.model.ConnectCasesRequest;
import software.amazon.awssdk.services.connectcases.model.FieldOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPutFieldOptionsRequest
extends ConnectCasesRequest
implements ToCopyableBuilder<Builder, BatchPutFieldOptionsRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(BatchPutFieldOptionsRequest.getter(BatchPutFieldOptionsRequest::domainId)).setter(BatchPutFieldOptionsRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainId").build()}).build();
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldId").getter(BatchPutFieldOptionsRequest.getter(BatchPutFieldOptionsRequest::fieldId)).setter(BatchPutFieldOptionsRequest.setter(Builder::fieldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("fieldId").build()}).build();
    private static final SdkField<List<FieldOption>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("options").getter(BatchPutFieldOptionsRequest.getter(BatchPutFieldOptionsRequest::options)).setter(BatchPutFieldOptionsRequest.setter(Builder::options)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, FIELD_ID_FIELD, OPTIONS_FIELD));
    private final String domainId;
    private final String fieldId;
    private final List<FieldOption> options;

    private BatchPutFieldOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.fieldId = builder.fieldId;
        this.options = builder.options;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String fieldId() {
        return this.fieldId;
    }

    public final boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructList);
    }

    public final List<FieldOption> options() {
        return this.options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptions() ? this.options() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutFieldOptionsRequest)) {
            return false;
        }
        BatchPutFieldOptionsRequest other = (BatchPutFieldOptionsRequest)((Object)obj);
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.fieldId(), other.fieldId()) && this.hasOptions() == other.hasOptions() && Objects.equals(this.options(), other.options());
    }

    public final String toString() {
        return ToString.builder((String)"BatchPutFieldOptionsRequest").add("DomainId", (Object)this.domainId()).add("FieldId", (Object)this.fieldId()).add("Options", this.hasOptions() ? this.options() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "fieldId": {
                return Optional.ofNullable(clazz.cast(this.fieldId()));
            }
            case "options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutFieldOptionsRequest, T> g) {
        return obj -> g.apply((BatchPutFieldOptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCasesRequest.BuilderImpl
    implements Builder {
        private String domainId;
        private String fieldId;
        private List<FieldOption> options = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutFieldOptionsRequest model) {
            super(model);
            this.domainId(model.domainId);
            this.fieldId(model.fieldId);
            this.options(model.options);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getFieldId() {
            return this.fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final List<FieldOption.Builder> getOptions() {
            List<FieldOption.Builder> result = BatchPutFieldOptionsRequestOptionsListCopier.copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptions(Collection<FieldOption.BuilderImpl> options) {
            this.options = BatchPutFieldOptionsRequestOptionsListCopier.copyFromBuilder(options);
        }

        @Override
        public final Builder options(Collection<FieldOption> options) {
            this.options = BatchPutFieldOptionsRequestOptionsListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(FieldOption ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<FieldOption.Builder> ... options) {
            this.options(Stream.of(options).map(c -> (FieldOption)((FieldOption.Builder)FieldOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchPutFieldOptionsRequest build() {
            return new BatchPutFieldOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectCasesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchPutFieldOptionsRequest> {
        public Builder domainId(String var1);

        public Builder fieldId(String var1);

        public Builder options(Collection<FieldOption> var1);

        public Builder options(FieldOption ... var1);

        public Builder options(Consumer<FieldOption.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

