/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcases.model.CaseFilterAndAllListCopier;
import software.amazon.awssdk.services.connectcases.model.CaseFilterOrAllListCopier;
import software.amazon.awssdk.services.connectcases.model.FieldFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CaseFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CaseFilter> {
    private static final SdkField<FieldFilter> FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("field").getter(CaseFilter.getter(CaseFilter::field)).setter(CaseFilter.setter(Builder::field)).constructor(FieldFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("field").build()}).build();
    private static final SdkField<CaseFilter> NOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("not").getter(CaseFilter.getter(CaseFilter::not)).setter(CaseFilter.setter(Builder::not)).constructor(CaseFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("not").build()}).build();
    private static final SdkField<List<CaseFilter>> AND_ALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("andAll").getter(CaseFilter.getter(CaseFilter::andAll)).setter(CaseFilter.setter(Builder::andAll)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("andAll").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CaseFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CaseFilter>> OR_ALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("orAll").getter(CaseFilter.getter(CaseFilter::orAll)).setter(CaseFilter.setter(Builder::orAll)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orAll").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CaseFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD, NOT_FIELD, AND_ALL_FIELD, OR_ALL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CaseFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final FieldFilter field;
    private final CaseFilter not;
    private final List<CaseFilter> andAll;
    private final List<CaseFilter> orAll;
    private final Type type;

    private CaseFilter(BuilderImpl builder) {
        this.field = builder.field;
        this.not = builder.not;
        this.andAll = builder.andAll;
        this.orAll = builder.orAll;
        this.type = builder.type;
    }

    public final FieldFilter field() {
        return this.field;
    }

    public final CaseFilter not() {
        return this.not;
    }

    public final boolean hasAndAll() {
        return this.andAll != null && !(this.andAll instanceof SdkAutoConstructList);
    }

    public final List<CaseFilter> andAll() {
        return this.andAll;
    }

    public final boolean hasOrAll() {
        return this.orAll != null && !(this.orAll instanceof SdkAutoConstructList);
    }

    public final List<CaseFilter> orAll() {
        return this.orAll;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.field());
        hashCode = 31 * hashCode + Objects.hashCode(this.not());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAndAll() ? this.andAll() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrAll() ? this.orAll() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseFilter)) {
            return false;
        }
        CaseFilter other = (CaseFilter)obj;
        return Objects.equals(this.field(), other.field()) && Objects.equals(this.not(), other.not()) && this.hasAndAll() == other.hasAndAll() && Objects.equals(this.andAll(), other.andAll()) && this.hasOrAll() == other.hasOrAll() && Objects.equals(this.orAll(), other.orAll());
    }

    public final String toString() {
        return ToString.builder((String)"CaseFilter").add("Field", (Object)this.field()).add("Not", (Object)this.not()).add("AndAll", this.hasAndAll() ? this.andAll() : null).add("OrAll", this.hasOrAll() ? this.orAll() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "field": {
                return Optional.ofNullable(clazz.cast(this.field()));
            }
            case "not": {
                return Optional.ofNullable(clazz.cast(this.not()));
            }
            case "andAll": {
                return Optional.ofNullable(clazz.cast(this.andAll()));
            }
            case "orAll": {
                return Optional.ofNullable(clazz.cast(this.orAll()));
            }
        }
        return Optional.empty();
    }

    public static CaseFilter fromField(FieldFilter field) {
        return (CaseFilter)CaseFilter.builder().field(field).build();
    }

    public static CaseFilter fromField(Consumer<FieldFilter.Builder> field) {
        FieldFilter.Builder builder = FieldFilter.builder();
        field.accept(builder);
        return CaseFilter.fromField((FieldFilter)builder.build());
    }

    public static CaseFilter fromNot(CaseFilter not) {
        return (CaseFilter)CaseFilter.builder().not(not).build();
    }

    public static CaseFilter fromNot(Consumer<Builder> not) {
        Builder builder = CaseFilter.builder();
        not.accept(builder);
        return CaseFilter.fromNot((CaseFilter)builder.build());
    }

    public static CaseFilter fromAndAll(List<CaseFilter> andAll) {
        return (CaseFilter)CaseFilter.builder().andAll(andAll).build();
    }

    public static CaseFilter fromOrAll(List<CaseFilter> orAll) {
        return (CaseFilter)CaseFilter.builder().orAll(orAll).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("field", FIELD_FIELD);
        map.put("not", NOT_FIELD);
        map.put("andAll", AND_ALL_FIELD);
        map.put("orAll", OR_ALL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CaseFilter, T> g) {
        return obj -> g.apply((CaseFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        FIELD,
        NOT,
        AND_ALL,
        OR_ALL,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private FieldFilter field;
        private CaseFilter not;
        private List<CaseFilter> andAll = DefaultSdkAutoConstructList.getInstance();
        private List<CaseFilter> orAll = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CaseFilter model) {
            this.field(model.field);
            this.not(model.not);
            this.andAll(model.andAll);
            this.orAll(model.orAll);
        }

        public final FieldFilter.Builder getField() {
            return this.field != null ? this.field.toBuilder() : null;
        }

        public final void setField(FieldFilter.BuilderImpl field) {
            FieldFilter oldValue = this.field;
            this.field = field != null ? field.build() : null;
            this.handleUnionValueChange(Type.FIELD, oldValue, this.field);
        }

        @Override
        public final Builder field(FieldFilter field) {
            FieldFilter oldValue = this.field;
            this.field = field;
            this.handleUnionValueChange(Type.FIELD, oldValue, this.field);
            return this;
        }

        public final Builder getNot() {
            return this.not != null ? this.not.toBuilder() : null;
        }

        public final void setNot(BuilderImpl not) {
            CaseFilter oldValue = this.not;
            this.not = not != null ? not.build() : null;
            this.handleUnionValueChange(Type.NOT, oldValue, this.not);
        }

        @Override
        public final Builder not(CaseFilter not) {
            CaseFilter oldValue = this.not;
            this.not = not;
            this.handleUnionValueChange(Type.NOT, oldValue, this.not);
            return this;
        }

        public final List<Builder> getAndAll() {
            List<Builder> result = CaseFilterAndAllListCopier.copyToBuilder(this.andAll);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndAll(Collection<BuilderImpl> andAll) {
            List<CaseFilter> oldValue = this.andAll;
            this.andAll = CaseFilterAndAllListCopier.copyFromBuilder(andAll);
            this.handleUnionValueChange(Type.AND_ALL, oldValue, this.andAll);
        }

        @Override
        public final Builder andAll(Collection<CaseFilter> andAll) {
            List<CaseFilter> oldValue = this.andAll;
            this.andAll = CaseFilterAndAllListCopier.copy(andAll);
            this.handleUnionValueChange(Type.AND_ALL, oldValue, this.andAll);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andAll(CaseFilter ... andAll) {
            this.andAll(Arrays.asList(andAll));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andAll(Consumer<Builder> ... andAll) {
            this.andAll(Stream.of(andAll).map(c -> (CaseFilter)((Builder)CaseFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getOrAll() {
            List<Builder> result = CaseFilterOrAllListCopier.copyToBuilder(this.orAll);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrAll(Collection<BuilderImpl> orAll) {
            List<CaseFilter> oldValue = this.orAll;
            this.orAll = CaseFilterOrAllListCopier.copyFromBuilder(orAll);
            this.handleUnionValueChange(Type.OR_ALL, oldValue, this.orAll);
        }

        @Override
        public final Builder orAll(Collection<CaseFilter> orAll) {
            List<CaseFilter> oldValue = this.orAll;
            this.orAll = CaseFilterOrAllListCopier.copy(orAll);
            this.handleUnionValueChange(Type.OR_ALL, oldValue, this.orAll);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orAll(CaseFilter ... orAll) {
            this.orAll(Arrays.asList(orAll));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orAll(Consumer<Builder> ... orAll) {
            this.orAll(Stream.of(orAll).map(c -> (CaseFilter)((Builder)CaseFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CaseFilter build() {
            return new CaseFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CaseFilter> {
        public Builder field(FieldFilter var1);

        default public Builder field(Consumer<FieldFilter.Builder> field) {
            return this.field((FieldFilter)((FieldFilter.Builder)FieldFilter.builder().applyMutation(field)).build());
        }

        public Builder not(CaseFilter var1);

        default public Builder not(Consumer<Builder> not) {
            return this.not((CaseFilter)((Builder)CaseFilter.builder().applyMutation(not)).build());
        }

        public Builder andAll(Collection<CaseFilter> var1);

        public Builder andAll(CaseFilter ... var1);

        public Builder andAll(Consumer<Builder> ... var1);

        public Builder orAll(Collection<CaseFilter> var1);

        public Builder orAll(CaseFilter ... var1);

        public Builder orAll(Consumer<Builder> ... var1);
    }
}

