/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.FieldValueUnion;
import software.amazon.awssdk.services.connectcases.model.SlaFieldValueUnionListCopier;
import software.amazon.awssdk.services.connectcases.model.SlaStatus;
import software.amazon.awssdk.services.connectcases.model.SlaType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SlaConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SlaConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(SlaConfiguration.getter(SlaConfiguration::name)).setter(SlaConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(SlaConfiguration.getter(SlaConfiguration::typeAsString)).setter(SlaConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SlaConfiguration.getter(SlaConfiguration::statusAsString)).setter(SlaConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldId").getter(SlaConfiguration.getter(SlaConfiguration::fieldId)).setter(SlaConfiguration.setter(Builder::fieldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldId").build()}).build();
    private static final SdkField<List<FieldValueUnion>> TARGET_FIELD_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetFieldValues").getter(SlaConfiguration.getter(SlaConfiguration::targetFieldValues)).setter(SlaConfiguration.setter(Builder::targetFieldValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetFieldValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldValueUnion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> TARGET_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("targetTime").getter(SlaConfiguration.getter(SlaConfiguration::targetTime)).setter(SlaConfiguration.setter(Builder::targetTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completionTime").getter(SlaConfiguration.getter(SlaConfiguration::completionTime)).setter(SlaConfiguration.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, STATUS_FIELD, FIELD_ID_FIELD, TARGET_FIELD_VALUES_FIELD, TARGET_TIME_FIELD, COMPLETION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SlaConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final String status;
    private final String fieldId;
    private final List<FieldValueUnion> targetFieldValues;
    private final Instant targetTime;
    private final Instant completionTime;

    private SlaConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.status = builder.status;
        this.fieldId = builder.fieldId;
        this.targetFieldValues = builder.targetFieldValues;
        this.targetTime = builder.targetTime;
        this.completionTime = builder.completionTime;
    }

    public final String name() {
        return this.name;
    }

    public final SlaType type() {
        return SlaType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final SlaStatus status() {
        return SlaStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String fieldId() {
        return this.fieldId;
    }

    public final boolean hasTargetFieldValues() {
        return this.targetFieldValues != null && !(this.targetFieldValues instanceof SdkAutoConstructList);
    }

    public final List<FieldValueUnion> targetFieldValues() {
        return this.targetFieldValues;
    }

    public final Instant targetTime() {
        return this.targetTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetFieldValues() ? this.targetFieldValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlaConfiguration)) {
            return false;
        }
        SlaConfiguration other = (SlaConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.fieldId(), other.fieldId()) && this.hasTargetFieldValues() == other.hasTargetFieldValues() && Objects.equals(this.targetFieldValues(), other.targetFieldValues()) && Objects.equals(this.targetTime(), other.targetTime()) && Objects.equals(this.completionTime(), other.completionTime());
    }

    public final String toString() {
        return ToString.builder((String)"SlaConfiguration").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).add("Status", (Object)this.statusAsString()).add("FieldId", (Object)this.fieldId()).add("TargetFieldValues", this.hasTargetFieldValues() ? this.targetFieldValues() : null).add("TargetTime", (Object)this.targetTime()).add("CompletionTime", (Object)this.completionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "fieldId": {
                return Optional.ofNullable(clazz.cast(this.fieldId()));
            }
            case "targetFieldValues": {
                return Optional.ofNullable(clazz.cast(this.targetFieldValues()));
            }
            case "targetTime": {
                return Optional.ofNullable(clazz.cast(this.targetTime()));
            }
            case "completionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("fieldId", FIELD_ID_FIELD);
        map.put("targetFieldValues", TARGET_FIELD_VALUES_FIELD);
        map.put("targetTime", TARGET_TIME_FIELD);
        map.put("completionTime", COMPLETION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlaConfiguration, T> g) {
        return obj -> g.apply((SlaConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String status;
        private String fieldId;
        private List<FieldValueUnion> targetFieldValues = DefaultSdkAutoConstructList.getInstance();
        private Instant targetTime;
        private Instant completionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SlaConfiguration model) {
            this.name(model.name);
            this.type(model.type);
            this.status(model.status);
            this.fieldId(model.fieldId);
            this.targetFieldValues(model.targetFieldValues);
            this.targetTime(model.targetTime);
            this.completionTime(model.completionTime);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SlaType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SlaStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFieldId() {
            return this.fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final List<FieldValueUnion.Builder> getTargetFieldValues() {
            List<FieldValueUnion.Builder> result = SlaFieldValueUnionListCopier.copyToBuilder(this.targetFieldValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetFieldValues(Collection<FieldValueUnion.BuilderImpl> targetFieldValues) {
            this.targetFieldValues = SlaFieldValueUnionListCopier.copyFromBuilder(targetFieldValues);
        }

        @Override
        public final Builder targetFieldValues(Collection<FieldValueUnion> targetFieldValues) {
            this.targetFieldValues = SlaFieldValueUnionListCopier.copy(targetFieldValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetFieldValues(FieldValueUnion ... targetFieldValues) {
            this.targetFieldValues(Arrays.asList(targetFieldValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetFieldValues(Consumer<FieldValueUnion.Builder> ... targetFieldValues) {
            this.targetFieldValues(Stream.of(targetFieldValues).map(c -> (FieldValueUnion)((FieldValueUnion.Builder)FieldValueUnion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getTargetTime() {
            return this.targetTime;
        }

        public final void setTargetTime(Instant targetTime) {
            this.targetTime = targetTime;
        }

        @Override
        public final Builder targetTime(Instant targetTime) {
            this.targetTime = targetTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public SlaConfiguration build() {
            return new SlaConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SlaConfiguration> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(SlaType var1);

        public Builder status(String var1);

        public Builder status(SlaStatus var1);

        public Builder fieldId(String var1);

        public Builder targetFieldValues(Collection<FieldValueUnion> var1);

        public Builder targetFieldValues(FieldValueUnion ... var1);

        public Builder targetFieldValues(Consumer<FieldValueUnion.Builder> ... var1);

        public Builder targetTime(Instant var1);

        public Builder completionTime(Instant var1);
    }
}

