/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesClient;
import software.amazon.awssdk.services.connectcases.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectcases.model.ListTemplatesRequest;
import software.amazon.awssdk.services.connectcases.model.ListTemplatesResponse;

public class ListTemplatesIterable
implements SdkIterable<ListTemplatesResponse> {
    private final ConnectCasesClient client;
    private final ListTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTemplatesIterable(ConnectCasesClient client, ListTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTemplatesResponseFetcher();
    }

    public Iterator<ListTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTemplatesResponseFetcher
    implements SyncPageFetcher<ListTemplatesResponse> {
        private ListTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTemplatesResponse nextPage(ListTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListTemplatesIterable.this.client.listTemplates(ListTemplatesIterable.this.firstRequest);
            }
            return ListTemplatesIterable.this.client.listTemplates((ListTemplatesRequest)((Object)ListTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

