/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcontactlens.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcontactlens.ConnectContactLensClient;
import software.amazon.awssdk.services.connectcontactlens.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsRequest;
import software.amazon.awssdk.services.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsResponse;

public class ListRealtimeContactAnalysisSegmentsIterable
implements SdkIterable<ListRealtimeContactAnalysisSegmentsResponse> {
    private final ConnectContactLensClient client;
    private final ListRealtimeContactAnalysisSegmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRealtimeContactAnalysisSegmentsIterable(ConnectContactLensClient client, ListRealtimeContactAnalysisSegmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRealtimeContactAnalysisSegmentsResponseFetcher();
    }

    public Iterator<ListRealtimeContactAnalysisSegmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListRealtimeContactAnalysisSegmentsResponseFetcher
    implements SyncPageFetcher<ListRealtimeContactAnalysisSegmentsResponse> {
        private ListRealtimeContactAnalysisSegmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListRealtimeContactAnalysisSegmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRealtimeContactAnalysisSegmentsResponse nextPage(ListRealtimeContactAnalysisSegmentsResponse previousPage) {
            if (previousPage == null) {
                return ListRealtimeContactAnalysisSegmentsIterable.this.client.listRealtimeContactAnalysisSegments(ListRealtimeContactAnalysisSegmentsIterable.this.firstRequest);
            }
            return ListRealtimeContactAnalysisSegmentsIterable.this.client.listRealtimeContactAnalysisSegments((ListRealtimeContactAnalysisSegmentsRequest)((Object)ListRealtimeContactAnalysisSegmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

