/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.endpoints.internal;

import java.util.Optional;
import java.util.concurrent.CompletionException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.connectparticipant.endpoints.ConnectParticipantEndpointParams;
import software.amazon.awssdk.services.connectparticipant.endpoints.ConnectParticipantEndpointProvider;
import software.amazon.awssdk.services.connectparticipant.endpoints.internal.AwsEndpointProviderUtils;

@SdkInternalApi
public final class ConnectParticipantResolveEndpointInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return context.request();
        }
        ConnectParticipantEndpointProvider provider = (ConnectParticipantEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Optional<String> hostPrefix;
            Endpoint result = provider.resolveEndpoint(ConnectParticipantResolveEndpointInterceptor.ruleParams(context, executionAttributes)).join();
            if (!AwsEndpointProviderUtils.disableHostPrefixInjection(executionAttributes) && (hostPrefix = ConnectParticipantResolveEndpointInterceptor.hostPrefix((String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME), context.request())).isPresent()) {
                result = AwsEndpointProviderUtils.addHostPrefix(result, hostPrefix.get());
            }
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, (Object)result);
            return context.request();
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create((String)"Endpoint resolution failed", (Throwable)cause);
        }
    }

    private static ConnectParticipantEndpointParams ruleParams(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        ConnectParticipantEndpointParams.Builder builder = ConnectParticipantEndpointParams.builder();
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        builder.useDualStack(AwsEndpointProviderUtils.dualStackEnabledBuiltIn(executionAttributes));
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        ConnectParticipantResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), context.request());
        ConnectParticipantResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        return builder.build();
    }

    private static void setContextParams(ConnectParticipantEndpointParams.Builder params, String operationName, SdkRequest request) {
    }

    private static void setStaticContextParams(ConnectParticipantEndpointParams.Builder params, String operationName) {
    }

    private static Optional<String> hostPrefix(String operationName, SdkRequest request) {
        return Optional.empty();
    }
}

