/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.controltower.model.LandingZoneOperationStatus;
import software.amazon.awssdk.services.controltower.model.LandingZoneOperationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LandingZoneOperationDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LandingZoneOperationDetail> {
    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationType").getter(LandingZoneOperationDetail.getter(LandingZoneOperationDetail::operationTypeAsString)).setter(LandingZoneOperationDetail.setter(Builder::operationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()}).build();
    private static final SdkField<String> OPERATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationIdentifier").getter(LandingZoneOperationDetail.getter(LandingZoneOperationDetail::operationIdentifier)).setter(LandingZoneOperationDetail.setter(Builder::operationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationIdentifier").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(LandingZoneOperationDetail.getter(LandingZoneOperationDetail::statusAsString)).setter(LandingZoneOperationDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(LandingZoneOperationDetail.getter(LandingZoneOperationDetail::startTime)).setter(LandingZoneOperationDetail.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(LandingZoneOperationDetail.getter(LandingZoneOperationDetail::endTime)).setter(LandingZoneOperationDetail.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(LandingZoneOperationDetail.getter(LandingZoneOperationDetail::statusMessage)).setter(LandingZoneOperationDetail.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_TYPE_FIELD, OPERATION_IDENTIFIER_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LandingZoneOperationDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String operationType;
    private final String operationIdentifier;
    private final String status;
    private final Instant startTime;
    private final Instant endTime;
    private final String statusMessage;

    private LandingZoneOperationDetail(BuilderImpl builder) {
        this.operationType = builder.operationType;
        this.operationIdentifier = builder.operationIdentifier;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.statusMessage = builder.statusMessage;
    }

    public final LandingZoneOperationType operationType() {
        return LandingZoneOperationType.fromValue(this.operationType);
    }

    public final String operationTypeAsString() {
        return this.operationType;
    }

    public final String operationIdentifier() {
        return this.operationIdentifier;
    }

    public final LandingZoneOperationStatus status() {
        return LandingZoneOperationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LandingZoneOperationDetail)) {
            return false;
        }
        LandingZoneOperationDetail other = (LandingZoneOperationDetail)obj;
        return Objects.equals(this.operationTypeAsString(), other.operationTypeAsString()) && Objects.equals(this.operationIdentifier(), other.operationIdentifier()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"LandingZoneOperationDetail").add("OperationType", (Object)this.operationTypeAsString()).add("OperationIdentifier", (Object)this.operationIdentifier()).add("Status", (Object)this.statusAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "operationType": {
                return Optional.ofNullable(clazz.cast(this.operationTypeAsString()));
            }
            case "operationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.operationIdentifier()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("operationType", OPERATION_TYPE_FIELD);
        map.put("operationIdentifier", OPERATION_IDENTIFIER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LandingZoneOperationDetail, T> g) {
        return obj -> g.apply((LandingZoneOperationDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operationType;
        private String operationIdentifier;
        private String status;
        private Instant startTime;
        private Instant endTime;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(LandingZoneOperationDetail model) {
            this.operationType(model.operationType);
            this.operationIdentifier(model.operationIdentifier);
            this.status(model.status);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.statusMessage(model.statusMessage);
        }

        public final String getOperationType() {
            return this.operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(LandingZoneOperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final String getOperationIdentifier() {
            return this.operationIdentifier;
        }

        public final void setOperationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
        }

        @Override
        public final Builder operationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LandingZoneOperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public LandingZoneOperationDetail build() {
            return new LandingZoneOperationDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LandingZoneOperationDetail> {
        public Builder operationType(String var1);

        public Builder operationType(LandingZoneOperationType var1);

        public Builder operationIdentifier(String var1);

        public Builder status(String var1);

        public Builder status(LandingZoneOperationStatus var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder statusMessage(String var1);
    }
}

