/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controltower.ControlTowerClient;
import software.amazon.awssdk.services.controltower.internal.UserAgentUtils;
import software.amazon.awssdk.services.controltower.model.BaselineSummary;
import software.amazon.awssdk.services.controltower.model.ListBaselinesRequest;
import software.amazon.awssdk.services.controltower.model.ListBaselinesResponse;

public class ListBaselinesIterable
implements SdkIterable<ListBaselinesResponse> {
    private final ControlTowerClient client;
    private final ListBaselinesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBaselinesIterable(ControlTowerClient client, ListBaselinesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBaselinesResponseFetcher();
    }

    public Iterator<ListBaselinesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BaselineSummary> baselines() {
        Function<ListBaselinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.baselines() != null) {
                return response.baselines().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBaselinesResponseFetcher
    implements SyncPageFetcher<ListBaselinesResponse> {
        private ListBaselinesResponseFetcher() {
        }

        public boolean hasNextPage(ListBaselinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBaselinesResponse nextPage(ListBaselinesResponse previousPage) {
            if (previousPage == null) {
                return ListBaselinesIterable.this.client.listBaselines(ListBaselinesIterable.this.firstRequest);
            }
            return ListBaselinesIterable.this.client.listBaselines((ListBaselinesRequest)((Object)ListBaselinesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

